/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.crypto.sm.spi;

import com.upay.sdk.crypto.CertificateReaderAdapter;
import com.upay.sdk.crypto.EncryptionAlgorithm;
import com.upay.sdk.crypto.codec.Base64;
import com.upay.sdk.crypto.sm.utils.SM2FileKeyUtils;
import com.upay.sdk.crypto.sm.utils.SMUtils;
import java.io.ByteArrayInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateReaderImpl
extends CertificateReaderAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CertificateReaderImpl.class);
    private static final String DEFAULT_PUBLIC_BASE64_KEY = "MIICvjCCAmGgAwIBAgIFE2YTh5AwDAYIKoEcz1UBg3UFADAlMQswCQYDVQQGEwJDTjEWMBQGA1UECgwNQ0ZDQSBTTTIgT0NBMTAeFw0yMjAzMjUwMTU1NTBaFw0yMzAzMjUwMTU1NTBaMIGiMQswCQYDVQQGEwJDTjEWMBQGA1UECgwNQ0ZDQSBTTTIgT0NBMTEQMA4GA1UECwwHUGF5RWFzZTEZMBcGA1UECwwQT3JnYW5pemF0aW9uYWwtMTFOMEwGA1UEAwxFUGF5RWFzZUDmmJPmmbrku5jnp5HmioDvvIjljJfkuqzvvInmnInpmZDlhazlj7hATjkxMTEwMTA4NzgzMjAwNTg1M0A0MFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAE2AQTFQek8d/KxadhwFAwcLP0Y31mubJsaWwIIJOl33sX4mSVnrsQMnYihCIKVU2uUw9Uzg0W1hFvycYN7sRYP6OB/TCB+jAfBgNVHSMEGDAWgBRck1ggWiRzVhAbZFAQ7OmnygdBETAJBgNVHRMEAjAAMEgGA1UdIARBMD8wPQYIYIEchu8qAQEwMTAvBggrBgEFBQcCARYjaHR0cDovL3d3dy5jZmNhLmNvbS5jbi91cy91cy0xNC5odG0wNwYDVR0fBDAwLjAsoCqgKIYmaHR0cDovL2NybC5jZmNhLmNvbS5jbi9TTTIvY3JsNjQzNC5jcmwwCwYDVR0PBAQDAgPoMB0GA1UdDgQWBBSwF+YXcEQK5Jnr3VUEnZuA5qW3pDAdBgNVHSUEFjAUBggrBgEFBQcDAgYIKwYBBQUHAwQwDAYIKoEcz1UBg3UFAANJADBGAiEAh2EdGm/Tsumpdu9eGXDK4jlGAP6q45OVJhz6iKKyksMCIQDq2AsM8VYMZSyoVgJjcpEVkg9xACA8+eF4670TmhmDNg==";

    protected String parsePrivateKey(byte[] byteData, char[] password) {
        try {
            return SM2FileKeyUtils.getPrivateKey(Base64.encode((byte[])byteData, (boolean)false), new String(password));
        }
        catch (Exception e) {
            LOGGER.error("sm2 parsePrivateKey error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected boolean canParsePrivateKey(byte[] byteData, char[] password) {
        return SMUtils.isSM2File(Base64.encode((byte[])byteData, (boolean)false), new String(password));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String parsePublicKey(byte[] byteData) {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(byteData);){
            String string = Base64.encode((byte[])SMUtils.readSM2PublishKey(inputStream));
            return string;
        }
        catch (Exception e) {
            LOGGER.error("sm2 parsePublicKey error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected String getDefaultPublicKey() {
        return this.parsePublicKey(Base64.decode((CharSequence)DEFAULT_PUBLIC_BASE64_KEY));
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return EncryptionAlgorithm.SM;
    }
}

