/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.crypto.sm.crypto;

import com.upay.sdk.crypto.codec.Base64;
import com.upay.sdk.crypto.exception.CryptoException;
import com.upay.sdk.crypto.sm.crypto.GlobalBouncyCastleProvider;
import com.upay.sdk.crypto.sm.crypto.KeyUtil;
import com.upay.sdk.crypto.utils.CryptoUtils;
import java.lang.reflect.Field;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;

public class SecureUtil {
    public static SecretKey generateKey(String algorithm) {
        return KeyUtil.generateKey(algorithm);
    }

    public static SecretKey generateKey(String algorithm, int keySize) {
        return KeyUtil.generateKey(algorithm, keySize);
    }

    public static SecretKey generateKey(String algorithm, byte[] key) {
        return KeyUtil.generateKey(algorithm, key);
    }

    public static SecretKey generateKey(String algorithm, KeySpec keySpec) {
        return KeyUtil.generateKey(algorithm, keySpec);
    }

    public static KeyPair generateKeyPair(String algorithm) {
        return KeyUtil.generateKeyPair(algorithm);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize) {
        return KeyUtil.generateKeyPair(algorithm, keySize);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize, byte[] seed) {
        return KeyUtil.generateKeyPair(algorithm, keySize, seed);
    }

    public static KeyPair generateKeyPair(String algorithm, AlgorithmParameterSpec params) {
        return KeyUtil.generateKeyPair(algorithm, params);
    }

    public static KeyPair generateKeyPair(String algorithm, byte[] seed, AlgorithmParameterSpec params) {
        return KeyUtil.generateKeyPair(algorithm, seed, params);
    }

    public static Certificate getCertificate(KeyStore keyStore, String alias) {
        return KeyUtil.getCertificate(keyStore, alias);
    }

    public static byte[] decode(String key) {
        return CryptoUtils.isHex((CharSequence)key) ? CryptoUtils.decodeHex((String)key) : Base64.decode((CharSequence)key);
    }

    public static Cipher createCipher(String algorithm) {
        Cipher cipher;
        Provider provider = GlobalBouncyCastleProvider.INSTANCE.getProvider();
        try {
            Field field;
            Class<?> clazz;
            if (System.getProperty("java.version").startsWith("1.6")) {
                clazz = Class.forName("javax.crypto.SunJCE_b");
                field = clazz.getDeclaredField("e");
                field.setAccessible(true);
                Map map = (Map)field.get(clazz);
                map.put(provider, Boolean.TRUE);
            } else {
                clazz = Class.forName("javax.crypto.JceSecurity");
                field = clazz.getDeclaredField("verificationResults");
                field.setAccessible(true);
                Map map = (Map)field.get(clazz);
                map.put(provider, Boolean.TRUE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            cipher = null == provider ? Cipher.getInstance(algorithm) : Cipher.getInstance(algorithm, provider);
        }
        catch (Exception e) {
            throw new CryptoException((Throwable)e);
        }
        return cipher;
    }

    public static MessageDigest createMessageDigest(String algorithm) {
        MessageDigest messageDigest;
        Provider provider = GlobalBouncyCastleProvider.INSTANCE.getProvider();
        try {
            messageDigest = null == provider ? MessageDigest.getInstance(algorithm) : MessageDigest.getInstance(algorithm, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException((Throwable)e);
        }
        return messageDigest;
    }

    public static Mac createMac(String algorithm) {
        Mac mac;
        Provider provider = GlobalBouncyCastleProvider.INSTANCE.getProvider();
        try {
            mac = null == provider ? Mac.getInstance(algorithm) : Mac.getInstance(algorithm, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException((Throwable)e);
        }
        return mac;
    }
}

