/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.crypto.sm.utils;

import com.upay.sdk.core.Environment;
import com.upay.sdk.crypto.codec.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.engines.SM4Engine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class SM2FileKeyUtils {
    private static final byte[] headBytes = "-----BEGIN CERTIFICATE-----".getBytes();
    private static final byte[] endBytes = "-----END CERTIFICATE-----".getBytes();
    private static final int headLength = headBytes.length;
    private static final int endLength = endBytes.length;

    public static String getPublicKey(byte[] sm2File) {
        ASN1Sequence asn1Sequence = ASN1Sequence.getInstance((Object)Base64.decode((byte[])sm2File));
        if (asn1Sequence != null && asn1Sequence.size() == 3) {
            return SM2FileKeyUtils.parseSM2Certs((ASN1Sequence)asn1Sequence.getObjectAt(2));
        }
        throw new RuntimeException("invalid SM2File encoding");
    }

    public static String getPrivateKey(byte[] sm2File, String password) throws Exception {
        ASN1Sequence asn1Sequence = ASN1Sequence.getInstance((Object)Base64.decode((byte[])sm2File));
        if (asn1Sequence != null && asn1Sequence.size() == 3) {
            return SM2FileKeyUtils.parsePrivateKey((ASN1Sequence)asn1Sequence.getObjectAt(1), password);
        }
        throw new RuntimeException("invalid SM2File encoding");
    }

    private static String parseSM2Certs(ASN1Sequence publicInfo) throws RuntimeException {
        if (publicInfo.size() != 2) {
            throw new RuntimeException("the sm2 file is not right format.can not get the public part");
        }
        ASN1OctetString pubOctString = (ASN1OctetString)publicInfo.getObjectAt(1);
        byte[] certBytes = SM2FileKeyUtils.filterPEMText(pubOctString.getOctets());
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)certBytes);
        Certificate certificate = Certificate.getInstance((Object)seq);
        SubjectPublicKeyInfo subjectPublicKeyInfo = certificate.getSubjectPublicKeyInfo();
        byte[] pubData = subjectPublicKeyInfo.getPublicKeyData().getBytes();
        return Base64.encode((byte[])pubData);
    }

    private static String parsePrivateKey(ASN1Sequence privateInfo, String password) throws Exception {
        if (privateInfo.size() != 3) {
            throw new RuntimeException("the sm2 file is not right format,can not get the private part");
        }
        ASN1OctetString priOctString = (ASN1OctetString)privateInfo.getObjectAt(2);
        byte[] encryptedData = priOctString.getOctets();
        byte[] dBytes = SM2FileKeyUtils.SM4DecryptDBytes(password, encryptedData);
        return Base64.encode((byte[])dBytes);
    }

    private static byte[] SM4DecryptDBytes(String password, byte[] encryptedData) throws InvalidCipherTextException {
        if (password != null && !password.isEmpty()) {
            byte[] passwordBytes = password.getBytes(Environment.DEFAULT_CHARSET);
            if (encryptedData != null && encryptedData.length != 0) {
                if (encryptedData.length >= 32 && encryptedData.length <= 64) {
                    byte[] dBytes;
                    byte[] encoding;
                    if (encryptedData.length != 32 && encryptedData.length != 48) {
                        try {
                            encoding = Base64.decode((byte[])encryptedData);
                        }
                        catch (Exception var21) {
                            throw new RuntimeException("SM2File EncryptedData required base64 ");
                        }
                    } else {
                        encoding = encryptedData;
                    }
                    byte[] hash = SM2FileKeyUtils.KDF(passwordBytes);
                    byte[] iv = new byte[16];
                    System.arraycopy(hash, 0, iv, 0, 16);
                    byte[] sm4 = new byte[16];
                    System.arraycopy(hash, 16, sm4, 0, 16);
                    PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new SM4Engine()), (BlockCipherPadding)new PKCS7Padding());
                    ParametersWithIV params = new ParametersWithIV((CipherParameters)new KeyParameter(sm4), iv);
                    cipher.init(false, (CipherParameters)params);
                    int outLength = cipher.getOutputSize(encoding.length);
                    byte[] out = new byte[outLength];
                    int dataLength = cipher.processBytes(encoding, 0, encoding.length, out, 0);
                    int lastLength = cipher.doFinal(out, dataLength);
                    int realLength = dataLength + lastLength;
                    if (realLength < outLength) {
                        dBytes = new byte[realLength];
                        System.arraycopy(out, 0, dBytes, 0, realLength);
                    } else {
                        dBytes = out;
                    }
                    return dBytes;
                }
                throw new RuntimeException("SM2File EncryptedData required length in [32-64] ");
            }
            throw new RuntimeException("SM2File encryptedData should not be null");
        }
        throw new RuntimeException("SM2File password should not be null");
    }

    private static byte[] KDF(byte[] z) {
        byte[] ct = new byte[]{0, 0, 0, 1};
        SM3Digest sm3 = new SM3Digest();
        sm3.update(z, 0, z.length);
        sm3.update(ct, 0, ct.length);
        byte[] hash = new byte[32];
        sm3.doFinal(hash, 0);
        return hash;
    }

    private static byte[] filterPEMText(byte[] certData) {
        byte[] certHead = new byte[headLength];
        byte[] certEnd = new byte[endLength];
        System.arraycopy(certData, 0, certHead, 0, headLength);
        boolean hasHead = Arrays.equals(certHead, headBytes);
        if (hasHead) {
            certData = SM2FileKeyUtils.deleteCRLF(certData);
        }
        int certDataLength = certData.length;
        System.arraycopy(certData, certDataLength - endLength, certEnd, 0, endLength);
        boolean hasEnd = Arrays.equals(certEnd, endBytes);
        int datStarter = 0;
        int datLength = 0;
        byte[] certBytes = null;
        if (hasHead && hasEnd) {
            datStarter = headLength;
            datLength = certDataLength - headLength - endLength;
        } else if (!hasHead && hasEnd) {
            datLength = certDataLength - endLength;
        } else if (hasHead) {
            datStarter = headLength;
            datLength = certDataLength - headLength;
        } else {
            certBytes = certData;
        }
        if (certBytes == null) {
            certBytes = new byte[datLength];
            System.arraycopy(certData, datStarter, certBytes, 0, certBytes.length);
        }
        return certBytes;
    }

    public static byte[] deleteCRLF(byte[] data) {
        byte tmp;
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((tmp = (byte)bis.read()) != -1) {
            if (tmp == 10 || tmp == 13) continue;
            bos.write(tmp);
        }
        return bos.toByteArray();
    }
}

