/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.crypto.sm.crypto.asymmetric;

import com.upay.sdk.crypto.codec.BCD;
import com.upay.sdk.crypto.codec.Base64;
import com.upay.sdk.crypto.sm.crypto.SecureUtil;
import com.upay.sdk.crypto.sm.crypto.asymmetric.AsymmetricDecryptor;
import com.upay.sdk.crypto.sm.crypto.asymmetric.AsymmetricEncryptor;
import com.upay.sdk.crypto.sm.crypto.asymmetric.BaseAsymmetric;
import com.upay.sdk.crypto.sm.crypto.asymmetric.KeyType;
import com.upay.sdk.crypto.utils.CryptoUtils;
import java.nio.charset.Charset;
import java.security.PrivateKey;
import java.security.PublicKey;

public abstract class AbstractAsymmetricCrypto<T extends AbstractAsymmetricCrypto<T>>
extends BaseAsymmetric<T>
implements AsymmetricEncryptor,
AsymmetricDecryptor {
    private static final long serialVersionUID = 1L;

    public AbstractAsymmetricCrypto(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        super(algorithm, privateKey, publicKey);
    }

    @Override
    public byte[] decrypt(String data, KeyType keyType) {
        return this.decrypt(SecureUtil.decode(data), keyType);
    }

    @Override
    public String decryptStr(String data, KeyType keyType, Charset charset) {
        return CryptoUtils.str((byte[])this.decrypt(data, keyType), (Charset)charset);
    }

    @Override
    public String decryptStr(String data, KeyType keyType) {
        return this.decryptStr(data, keyType, CryptoUtils.CHARSET_UTF_8);
    }

    @Override
    public byte[] decryptFromBcd(String data, KeyType keyType) {
        return this.decryptFromBcd(data, keyType, CryptoUtils.CHARSET_UTF_8);
    }

    @Override
    public byte[] decryptFromBcd(String data, KeyType keyType, Charset charset) {
        byte[] dataBytes = BCD.ascToBcd((byte[])CryptoUtils.bytes((CharSequence)data, (Charset)charset));
        return this.decrypt(dataBytes, keyType);
    }

    @Override
    public String decryptStrFromBcd(String data, KeyType keyType, Charset charset) {
        return CryptoUtils.str((byte[])this.decryptFromBcd(data, keyType, charset), (Charset)charset);
    }

    @Override
    public String decryptStrFromBcd(String data, KeyType keyType) {
        return this.decryptStrFromBcd(data, keyType, CryptoUtils.CHARSET_UTF_8);
    }

    @Override
    public String encryptHex(byte[] data, KeyType keyType) {
        return CryptoUtils.encodeHexStr((byte[])this.encrypt(data, keyType));
    }

    @Override
    public String encryptBase64(byte[] data, KeyType keyType) {
        return Base64.encode((byte[])this.encrypt(data, keyType));
    }

    @Override
    public byte[] encrypt(String data, String charset, KeyType keyType) {
        return this.encrypt(CryptoUtils.bytes((CharSequence)data, (Charset)CryptoUtils.charset((String)charset)), keyType);
    }

    @Override
    public byte[] encrypt(String data, Charset charset, KeyType keyType) {
        return this.encrypt(CryptoUtils.bytes((CharSequence)data, (Charset)charset), keyType);
    }

    @Override
    public byte[] encrypt(String data, KeyType keyType) {
        return this.encrypt(CryptoUtils.utf8Bytes((CharSequence)data), keyType);
    }

    @Override
    public String encryptHex(String data, KeyType keyType) {
        return CryptoUtils.encodeHexStr((byte[])this.encrypt(data, keyType));
    }

    @Override
    public String encryptHex(String data, Charset charset, KeyType keyType) {
        return CryptoUtils.encodeHexStr((byte[])this.encrypt(data, charset, keyType));
    }

    @Override
    public String encryptBase64(String data, KeyType keyType) {
        return Base64.encode((byte[])this.encrypt(data, keyType));
    }

    @Override
    public String encryptBase64(String data, Charset charset, KeyType keyType) {
        return Base64.encode((byte[])this.encrypt(data, charset, keyType));
    }

    @Override
    public String encryptBcd(String data, KeyType keyType) {
        return this.encryptBcd(data, keyType, CryptoUtils.CHARSET_UTF_8);
    }

    @Override
    public String encryptBcd(String data, KeyType keyType, Charset charset) {
        return BCD.bcdToStr((byte[])this.encrypt(data, charset, keyType));
    }
}

