/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.crypto.sm.crypto;

import java.security.SecureRandom;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;

public class RandomUtil {
    public static final String BASE_NUMBER = "0123456789";
    public static final String BASE_CHAR = "abcdefghijklmnopqrstuvwxyz";
    public static final String BASE_CHAR_NUMBER = "abcdefghijklmnopqrstuvwxyz0123456789";

    public static Random getRandom() {
        return new Random();
    }

    public static SecureRandom createSecureRandom(byte[] seed) {
        return null == seed ? new SecureRandom() : new SecureRandom(seed);
    }

    public static SecureRandom getSecureRandom() {
        return RandomUtil.getSecureRandom(null);
    }

    public static SecureRandom getSecureRandom(byte[] seed) {
        return RandomUtil.createSecureRandom(seed);
    }

    public static Random getRandom(boolean isSecure) {
        return isSecure ? RandomUtil.getSecureRandom() : RandomUtil.getRandom();
    }

    public static int randomInt() {
        return RandomUtil.getRandom().nextInt();
    }

    public static int randomInt(int limit) {
        return RandomUtil.getRandom().nextInt(limit);
    }

    public static String randomString(int length) {
        return RandomUtil.randomString(BASE_CHAR_NUMBER, length);
    }

    public static String randomString(String baseString, int length) {
        if (StringUtils.isEmpty((CharSequence)baseString)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(length);
        if (length < 1) {
            length = 1;
        }
        int baseLength = baseString.length();
        for (int i = 0; i < length; ++i) {
            int number = RandomUtil.randomInt(baseLength);
            sb.append(baseString.charAt(number));
        }
        return sb.toString();
    }

    public static byte[] randomBytes(int length) {
        byte[] bytes = new byte[length];
        RandomUtil.getRandom().nextBytes(bytes);
        return bytes;
    }
}

