/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.webox.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;

public class UserQuotaQueryBuilder
extends BuilderSupport {
    private String userId;
    private String idCardNo;
    private String name;
    private String requestId;
    private String merchantId;

    public UserQuotaQueryBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public UserQuotaQueryBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public UserQuotaQueryBuilder setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public UserQuotaQueryBuilder setIdCardNo(String idCardNo) {
        this.idCardNo = idCardNo;
        return this;
    }

    public UserQuotaQueryBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public UserQuotaQueryBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        return SignUtils.signMd5(orderGenerateHmac, ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

