/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.transfer.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.transfer.ConstantsTransfer;
import com.upay.sdk.transfer.builder.ListpriceLockBuilder;
import com.upay.sdk.transfer.builder.OrderBuilder;
import com.upay.sdk.transfer.builder.QueryBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferOrderExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(TransferOrderExecuter.class);

    public void bothOrder(OrderBuilder builder, ResultListener resultListener) {
        LOGGER.debug("TransferOrderExecuter bothOrder  data:[" + ToStringBuilder.reflectionToString((Object)builder) + "]");
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("TransferOrderExecuter bothOrder requestData:[" + requestData.toJSONString() + "],TransferOrderUrl:[" + ConfigurationUtils.getTransferOrderUrl() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getTransferOrderUrl(), requestData);
        LOGGER.debug("TransferOrderExecuter bothOrder responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.debug("responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!ConstantsTransfer.SUCCESS.equals(responseData.getString(ConstantsTransfer.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void bothCipherCallback(JSONObject responseData, ResultListener foreignExchangeListener, ResultListener transferListener) {
        if (foreignExchangeListener == null || transferListener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.info("TransferOrderExecuter bothCipherCallback data:[" + data + "]");
        this.bothVerifyHmacOrder(data);
        if (data != null) {
            String status;
            JSONObject foreignExchangeJson = data.getJSONObject("foreignExchangeResponse");
            if (foreignExchangeJson != null) {
                status = foreignExchangeJson.getString(Constants.STATUS);
                if (Constants.SUCCESS.equals(status)) {
                    foreignExchangeListener.success(data);
                } else {
                    if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                        foreignExchangeListener.failure(data);
                        return;
                    }
                    if (!Constants.INIT.equals(status)) throw new ResponseException(data);
                    foreignExchangeListener.pending(data);
                    return;
                }
            }
            if (ConstantsTransfer.SUCCESS.equals(status = data.getString(ConstantsTransfer.STATUS))) {
                transferListener.success(data);
                return;
            } else if (ConstantsTransfer.FAILED.equals(status) || ConstantsTransfer.CANCEL.equals(status)) {
                transferListener.failure(data);
                return;
            } else {
                if (!ConstantsTransfer.INIT.equals(status) && !ConstantsTransfer.PROCESSING.equals(status) && !ConstantsTransfer.PAID.equals(status) && !ConstantsTransfer.REMITTED.equals(status)) throw new ResponseException(data);
                transferListener.pending(data);
            }
            return;
        } else {
            LOGGER.info("do nothing.", (Object)data);
        }
    }

    public void bothQuery(QueryBuilder builder, ResultListener foreignExchangeListener, ResultListener transferListener) {
        if (foreignExchangeListener == null || transferListener == null) {
            throw new NullPointerException();
        }
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("TransferOrderExecuter bothQuery requestData:[" + requestData + "],transferQueryUrl:[" + ConfigurationUtils.getTransferQueryUrl() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getTransferQueryUrl(), requestData);
        LOGGER.debug("responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        this.bothCipherCallback(responseData, transferListener, foreignExchangeListener);
    }

    public void bothLock(ListpriceLockBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.info("TransferOrderExecuter bothLock requestData:[" + requestData + "],transferListpriceLockUrl:[" + ConfigurationUtils.getTransferListpriceLockUrl() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getTransferListpriceLockUrl(), requestData);
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        LOGGER.debug("TransferOrderExecuter bothLock responseStr:[" + responseStr + "]");
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        this.bothVerifyHmacOrder(data);
        if (!ConstantsTransfer.SUCCESS.equals(data.getString(ConstantsTransfer.STATUS))) {
            throw new ResponseException(data);
        }
        listener.success(data);
    }
}

