/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.serviceprovider.v3_0.report.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.serviceprovider.v3_0.report.builder.WeChatApiReportBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatApiReportExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(WechatApiReportExecuter.class);

    public void declare(WeChatApiReportBuilder builder, ResultListener resultListener) {
        block5: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.debug("WechatApiReportExecuter requestData:[" + requestData.toJSONString() + "]");
                String serviceProviderWechatApiReportUrl = ConfigurationUtils.getServiceProviderWechatApiReportUrl();
                LOGGER.info("WechatApiReportExecuter url:[" + serviceProviderWechatApiReportUrl + "]");
                String responseStr = HttpClientUtils.post3(serviceProviderWechatApiReportUrl, requestData);
                LOGGER.info("WechatApiReportExecuter responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.info("WechatApiReportExecuter responseData:[" + responseData + "]");
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block5;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block5;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("WechatApiReportExecuter error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void callBack(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        LOGGER.info("WechatApiReport callBack responseStr:[" + responseData + "]");
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.info("WechatApiReport callBack responseData:[" + data + "]");
        this.bothVerifyHmacOrder(data);
        listener.success(data);
    }
}

