/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.serviceprovider.v3_0.report.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;
import org.apache.commons.lang3.StringUtils;

public class WeChatConfigReportBuilder
extends BuilderSupport {
    private String partnerId;
    private String merchantId;
    private String reportRequestId;
    private String requestId;
    private String configType;
    private String configInfo;
    private String appType;

    public WeChatConfigReportBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    public WeChatConfigReportBuilder setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    public WeChatConfigReportBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public WeChatConfigReportBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public WeChatConfigReportBuilder setConfigType(String configType) {
        this.configType = configType;
        return this;
    }

    public WeChatConfigReportBuilder setConfigInfo(String configInfo) {
        this.configInfo = configInfo;
        return this;
    }

    public WeChatConfigReportBuilder setReportRequestId(String reportRequestId) {
        this.reportRequestId = reportRequestId;
        return this;
    }

    public WeChatConfigReportBuilder setAppType(String appType) {
        this.appType = appType;
        return this;
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getConfigType() {
        return this.configType;
    }

    public String getConfigInfo() {
        return this.configInfo;
    }

    public String getReportRequestId() {
        return this.reportRequestId;
    }

    public String getAppType() {
        return this.appType;
    }
}

