/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.serviceprovider.v3_0.report.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;
import org.apache.commons.lang3.StringUtils;

public class AliPayApiReportBuilder
extends BuilderSupport {
    private String partnerId;
    private String merchantId;
    private String requestId;
    private String channelType;
    private String distributorNo;
    private String merchantShortName;
    private String name;
    private String mobile;
    private String email;
    private String tag;
    private String type;
    private String servicePhone;
    private String indirectLevel;

    public AliPayApiReportBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getChannelType() {
        return this.channelType;
    }

    public String getDistributorNo() {
        return this.distributorNo;
    }

    public String getMerchantShortName() {
        return this.merchantShortName;
    }

    public String getName() {
        return this.name;
    }

    public String getMobile() {
        return this.mobile;
    }

    public String getEmail() {
        return this.email;
    }

    public String getTag() {
        return this.tag;
    }

    public String getType() {
        return this.type;
    }

    public String getServicePhone() {
        return this.servicePhone;
    }

    public String getIndirectLevel() {
        return this.indirectLevel;
    }

    public AliPayApiReportBuilder setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    public AliPayApiReportBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public AliPayApiReportBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public AliPayApiReportBuilder setChannelType(String channelType) {
        this.channelType = channelType;
        return this;
    }

    public AliPayApiReportBuilder setDistributorNo(String distributorNo) {
        this.distributorNo = distributorNo;
        return this;
    }

    public AliPayApiReportBuilder setMerchantShortName(String merchantShortName) {
        this.merchantShortName = merchantShortName;
        return this;
    }

    public AliPayApiReportBuilder setServicePhone(String servicePhone) {
        this.servicePhone = servicePhone;
        return this;
    }

    public AliPayApiReportBuilder setIndirectLevel(String indirectLevel) {
        this.indirectLevel = indirectLevel;
        return this;
    }

    public AliPayApiReportBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public AliPayApiReportBuilder setMobile(String mobile) {
        this.mobile = mobile;
        return this;
    }

    public AliPayApiReportBuilder setEmail(String email) {
        this.email = email;
        return this;
    }

    public AliPayApiReportBuilder setTag(String tag) {
        this.tag = tag;
        return this;
    }

    public AliPayApiReportBuilder setType(String type) {
        this.type = type;
        return this;
    }
}

