/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.phoenix.v_1.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnBindCardExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(UnBindCardExecuter.class);

    public void unBindCard(JSONObject requestData, ResultListener resultListener) {
        LOGGER.debug("unBindCard requestData:[" + requestData.toJSONString() + "]");
        LOGGER.info("url:" + ConfigurationUtils.getPhoenixUnBindCardUrl());
        String responseStr = HttpClientUtils.post(ConfigurationUtils.getPhoenixUnBindCardUrl(), requestData.toJSONString());
        LOGGER.debug("unBindCard responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        responseData = CipherWrapper.decryptWrap(responseData);
        this.verifyHmacOrder(responseData);
        String status = responseData.getString(Constants.STATUS);
        if (Constants.SUCCESS.equals(status)) {
            resultListener.success(responseData);
        } else if (Constants.ERROR.equals(status)) {
            resultListener.failure(responseData);
        } else {
            throw new ResponseException(responseData);
        }
    }
}

