/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.phoenix.v_1.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.phoenix.v_1.builder.OrderBuilder;
import com.upay.sdk.phoenix.v_1.builder.QueryBuilder;
import com.upay.sdk.phoenix.v_1.builder.RefundBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(OrderExecuter.class);

    public void refund(RefundBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        String responseStr = HttpClientUtils.post2(ConfigurationUtils.getPhoenixRefundUrl(), builder.encryptBuild());
        LOGGER.debug("responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.decryptWrap(responseData);
        this.verifyHmacOrder(responseData);
        status = responseData.getString(Constants.STATUS);
        if (Constants.SUCCESS.equals(status)) {
            listener.success(responseData);
        } else if (Constants.FAILED.equals(status)) {
            listener.failure(responseData);
        } else if (Constants.INIT.equals(status)) {
            listener.pending(responseData);
        } else {
            throw new ResponseException(responseData);
        }
    }

    public void order(OrderBuilder builder, ResultListener resultListener) {
        block5: {
            try {
                JSONObject requestData = builder.encryptBuild();
                LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
                String phoenixOrderUrl = ConfigurationUtils.getPhoenixOrderUrl();
                String responseStr = HttpClientUtils.post2(phoenixOrderUrl, requestData);
                JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                responseData = CipherWrapper.decryptWrap(responseData);
                LOGGER.debug("responseStr:[" + responseData + "]");
                this.verifyHmacOrder(responseData);
                if (Constants.REDIRECT.equals(responseData.getString(Constants.STATUS))) {
                    resultListener.redirect(responseData, responseData.getString("redirectUrl"));
                    break block5;
                }
                if (Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                    resultListener.success(responseData);
                    break block5;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("request order exception", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void query(QueryBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.encryptBuild();
            LOGGER.debug("requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post2(ConfigurationUtils.getPhoenixQueryUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                LOGGER.debug("decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            LOGGER.debug("responseStr:[" + responseStr + "]");
            this.cipherCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void cipherCallback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.decryptWrap(responseData);
        this.verifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        if (StringUtils.isNotBlank((CharSequence)status)) {
            if (Constants.SUCCESS.equals(status)) {
                listener.success(data);
            } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                listener.failure(data);
            } else if (Constants.INIT.equals(status)) {
                listener.pending(data);
            } else {
                throw new ResponseException(data);
            }
        }
    }

    public void refundQuery(RefundBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            String responseStr = HttpClientUtils.post2(ConfigurationUtils.getPhoenixRefundQueryUrl(), builder.encryptBuild());
            LOGGER.debug("responseStr:[" + responseStr + "]");
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                LOGGER.debug("decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            LOGGER.debug("responseStr:[" + responseStr + "]");
            this.cipherRefundCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void cipherRefundCallback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        responseData = CipherWrapper.decryptWrap(responseData);
        this.verifyHmacOrder(responseData);
        String status = responseData.getString(Constants.STATUS);
        if (Constants.SUCCESS.equals(status)) {
            listener.success(responseData);
        } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
            listener.failure(responseData);
        } else if (Constants.INIT.equals(status)) {
            listener.pending(responseData);
        } else {
            throw new ResponseException(responseData);
        }
    }
}

