/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.phoenix.v_1.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindCardExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(BindCardExecuter.class);

    public void bindCard(JSONObject requestData, ResultListener resultListener) {
        LOGGER.debug("bindCard requestData:[" + requestData.toJSONString() + "]");
        LOGGER.info("url:" + ConfigurationUtils.getPhoenixBindCardUrl());
        String responseStr = HttpClientUtils.post2(ConfigurationUtils.getPhoenixBindCardUrl(), requestData);
        LOGGER.debug("bindCard responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        responseData = CipherWrapper.decryptWrap(responseData);
        this.verifyHmacOrder(responseData);
        String status = responseData.getString(Constants.STATUS);
        if (Constants.SUCCESS.equals(status)) {
            resultListener.success(responseData);
        } else if (Constants.FAILED.equals(status)) {
            resultListener.failure(responseData);
        } else {
            throw new ResponseException(responseData);
        }
    }

    public void bindCardConfirm(JSONObject requestData, ResultListener resultListener) {
        LOGGER.debug("bindCardConfirm requestData:[" + requestData.toJSONString() + "]");
        LOGGER.info("url:" + ConfigurationUtils.getPhoenixBindCardConfirmUrl());
        String responseStr = HttpClientUtils.post2(ConfigurationUtils.getPhoenixBindCardConfirmUrl(), requestData);
        LOGGER.debug("bindCardConfirm responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        responseData = CipherWrapper.decryptWrap(responseData);
        this.verifyHmacOrder(responseData);
        String status = responseData.getString(Constants.STATUS);
        if (Constants.SUCCESS.equals(status)) {
            resultListener.success(responseData);
        } else if (Constants.FAILED.equals(status)) {
            resultListener.failure(responseData);
        } else {
            throw new ResponseException(responseData);
        }
    }

    public void bindCardQuery(JSONObject requestData, ResultListener resultListener) {
        LOGGER.debug("bindCardQuery requestData:[" + requestData.toJSONString() + "]");
        LOGGER.info("url:" + ConfigurationUtils.getPhoenixBindCardQueryUrl());
        String responseStr = HttpClientUtils.post2(ConfigurationUtils.getPhoenixBindCardQueryUrl(), requestData);
        LOGGER.debug("bindCardQuery responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        responseData = CipherWrapper.decryptWrap(responseData);
        this.verifyHmacOrder(responseData);
        String status = responseData.getString(Constants.STATUS);
        if (Constants.SUCCESS.equals(status)) {
            resultListener.success(responseData);
        } else if (Constants.FAILED.equals(status)) {
            resultListener.failure(responseData);
        } else {
            throw new ResponseException(responseData);
        }
    }

    public void unbindCard(JSONObject requestData, ResultListener resultListener) {
        LOGGER.debug("unbindCard requestData:[" + requestData.toJSONString() + "]");
        LOGGER.info("url:" + ConfigurationUtils.getPhoenixUnBindCardUrl());
        String responseStr = HttpClientUtils.post2(ConfigurationUtils.getPhoenixUnBindCardUrl(), requestData);
        LOGGER.debug("unbindCard responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        responseData = CipherWrapper.decryptWrap(responseData);
        this.verifyHmacOrder(responseData);
        String status = responseData.getString(Constants.STATUS);
        if (Constants.SUCCESS.equals(status)) {
            resultListener.success(responseData);
        } else if (Constants.ERROR.equals(status)) {
            resultListener.failure(responseData);
        } else {
            throw new ResponseException(responseData);
        }
    }
}

