/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.phoenix.v_1.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.entity.ProductDetail;
import com.upay.sdk.entity.WeixinH5SceneInfo;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public final class OrderBuilder
extends BuilderSupport {
    private String merchantId;
    private String orderAmount;
    private String orderCurrency;
    private String requestId;
    private String notifyUrl;
    private String callbackUrl;
    private String remark;
    private String paymentModeCode;
    private String clientIp;
    private String timeout;
    private String authCode;
    private String openId;
    private String accountName;
    private String bankCardNumber;
    private String cvv2;
    private String idCardNum;
    private String bankCardTermOfValidity;
    private String phoneNumber;
    private String agreementNo;
    private String subAppId;
    private List<ProductDetail> productDetails = new LinkedList<ProductDetail>();
    private WeixinH5SceneInfo weixinH5SceneInfo;

    public OrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public OrderBuilder setOrderAmount(String orderAmount) {
        this.orderAmount = orderAmount;
        return this;
    }

    public OrderBuilder setOrderCurrency(String orderCurrency) {
        this.orderCurrency = orderCurrency;
        return this;
    }

    public OrderBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public OrderBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public OrderBuilder setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public OrderBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public OrderBuilder setPaymentModeCode(String paymentModeCode) {
        this.paymentModeCode = paymentModeCode;
        return this;
    }

    public OrderBuilder setAuthCode(String authCode) {
        this.authCode = authCode;
        return this;
    }

    public OrderBuilder setOpenId(String openId) {
        this.openId = openId;
        return this;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public OrderBuilder setAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    public OrderBuilder setBankCardNumber(String bankCardNumber) {
        this.bankCardNumber = bankCardNumber;
        return this;
    }

    public OrderBuilder setCvv2(String cvv2) {
        this.cvv2 = cvv2;
        return this;
    }

    public OrderBuilder setIdCardNum(String idCardNum) {
        this.idCardNum = idCardNum;
        return this;
    }

    public OrderBuilder setBankCardTermOfValidity(String bankCardTermOfValidity) {
        this.bankCardTermOfValidity = bankCardTermOfValidity;
        return this;
    }

    public OrderBuilder setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    public OrderBuilder setAgreementNo(String agreementNo) {
        this.agreementNo = agreementNo;
        return this;
    }

    public OrderBuilder setSubAppId(String subAppId) {
        this.subAppId = subAppId;
        return this;
    }

    public OrderBuilder addProductDetail(ProductDetail productDetail) {
        this.productDetails.add(productDetail);
        return this;
    }

    public OrderBuilder setWeixinH5SceneInfo(WeixinH5SceneInfo weixinH5SceneInfo) {
        this.weixinH5SceneInfo = weixinH5SceneInfo;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.orderAmount)) {
            json.put("orderAmount", (Object)this.orderAmount);
        }
        if (StringUtils.isNotBlank((CharSequence)this.orderCurrency)) {
            json.put("orderCurrency", (Object)this.orderCurrency);
        }
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.notifyUrl)) {
            json.put("notifyUrl", (Object)this.notifyUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)this.callbackUrl)) {
            json.put("callbackUrl", (Object)this.callbackUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)this.remark)) {
            json.put("remark", (Object)this.remark);
        }
        if (StringUtils.isNotBlank((CharSequence)this.paymentModeCode)) {
            json.put("paymentModeCode", (Object)this.paymentModeCode);
        }
        if (StringUtils.isNotBlank((CharSequence)this.authCode)) {
            json.put("authCode", (Object)this.authCode);
        }
        if (StringUtils.isNotBlank((CharSequence)this.openId)) {
            json.put("openId", (Object)this.openId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.clientIp)) {
            json.put("clientIp", (Object)this.clientIp);
        }
        if (StringUtils.isNotBlank((CharSequence)this.timeout)) {
            json.put("timeout", (Object)this.timeout);
        }
        json.put("productDetails", this.productDetails);
        if (StringUtils.isNotBlank((CharSequence)this.accountName)) {
            json.put("accountName", (Object)this.accountName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.bankCardNumber)) {
            json.put("bankCardNumber", (Object)this.bankCardNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)this.idCardNum)) {
            json.put("idCardNum", (Object)this.idCardNum);
        }
        if (StringUtils.isNotBlank((CharSequence)this.phoneNumber)) {
            json.put("phoneNumber", (Object)this.phoneNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)this.cvv2)) {
            json.put("cvv2", (Object)this.cvv2);
        }
        if (StringUtils.isNotBlank((CharSequence)this.bankCardTermOfValidity)) {
            json.put("bankCardTermOfValidity", (Object)this.bankCardTermOfValidity);
        }
        if (StringUtils.isNotBlank((CharSequence)this.agreementNo)) {
            json.put("agreementNo", (Object)this.agreementNo);
        }
        if (StringUtils.isNotBlank((CharSequence)this.subAppId)) {
            json.put("subAppId", (Object)this.subAppId);
        }
        json.put("weixinH5SceneInfo", (Object)this.weixinH5SceneInfo);
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append((String)ObjectUtils.defaultIfNull((Object)this.orderAmount, (Object)"")).append(StringUtils.defaultString((String)this.orderCurrency, (String)"")).append(StringUtils.defaultString((String)this.requestId, (String)"")).append(StringUtils.defaultString((String)this.paymentModeCode, (String)""));
        if (this.productDetails != null) {
            for (ProductDetail productDetail : this.productDetails) {
                hmacSource.append(StringUtils.defaultString((String)productDetail.getName())).append(ObjectUtils.defaultIfNull((Object)productDetail.getQuantity(), (Object)"")).append(ObjectUtils.defaultIfNull((Object)productDetail.getAmount(), (Object)"")).append(StringUtils.defaultString((String)productDetail.getReceiver())).append(StringUtils.defaultString((String)productDetail.getDescription()));
            }
        }
        hmacSource.append(StringUtils.defaultString((String)this.notifyUrl, (String)"")).append(StringUtils.defaultString((String)this.callbackUrl, (String)"")).append(StringUtils.defaultString((String)this.remark, (String)"")).append(StringUtils.defaultString((String)this.clientIp, (String)"")).append((String)ObjectUtils.defaultIfNull((Object)this.timeout, (Object)"")).append((String)ObjectUtils.defaultIfNull((Object)this.authCode, (Object)"")).append((String)ObjectUtils.defaultIfNull((Object)this.openId, (Object)"")).append((String)ObjectUtils.defaultIfNull((Object)this.accountName, (Object)"")).append((String)ObjectUtils.defaultIfNull((Object)this.bankCardNumber, (Object)"")).append((String)ObjectUtils.defaultIfNull((Object)this.idCardNum, (Object)"")).append((String)ObjectUtils.defaultIfNull((Object)this.phoneNumber, (Object)"")).append((String)ObjectUtils.defaultIfNull((Object)this.cvv2, (Object)"")).append((String)ObjectUtils.defaultIfNull((Object)this.bankCardTermOfValidity, (Object)"")).append((String)ObjectUtils.defaultIfNull((Object)this.agreementNo, (Object)"")).append((String)ObjectUtils.defaultIfNull((Object)this.subAppId, (Object)""));
        if (this.weixinH5SceneInfo != null) {
            hmacSource.append(StringUtils.defaultString((String)this.weixinH5SceneInfo.getSceneType(), (String)"")).append(StringUtils.defaultString((String)this.weixinH5SceneInfo.getSceneName(), (String)"")).append(StringUtils.defaultString((String)this.weixinH5SceneInfo.getSceneUrl(), (String)""));
        }
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(this.merchantId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }
}

