/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.onlinepay.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.entity.SplitDetail;
import com.upay.sdk.exception.UnknownException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class SplitOrderBuilder
extends BuilderSupport {
    private String merchantId;
    private String orderId;
    private String requestId;
    private String totalSplitAmount;
    private String notifyUrl;
    private String partnerId;
    private List<SplitDetail> splitDetails = new LinkedList<SplitDetail>();

    public SplitOrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public SplitOrderBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public SplitOrderBuilder setOrderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public SplitOrderBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    public String getTotalSplitAmount() {
        return this.totalSplitAmount;
    }

    public SplitOrderBuilder setTotalSplitAmount(String totalSplitAmount) {
        this.totalSplitAmount = totalSplitAmount;
        return this;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public SplitOrderBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public SplitOrderBuilder addSplitDetails(SplitDetail splitDetail) {
        this.splitDetails.add(splitDetail);
        return this;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

