/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.listprice.executer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.listprice.builder.ObtainListPriceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObtainListPriceExecuter
extends Executer {
    private static final Logger log = LoggerFactory.getLogger(ObtainListPriceExecuter.class);

    public void obtainListPriceV3(ObtainListPriceBuilder builder, ResultListener resultListener) {
        log.info("ObtainListPriceExecuter ObtainListPriceV3 builder:[" + JSON.toJSONString((Object)builder) + "]");
        JSONObject requestData = builder.bothEncryptBuild();
        log.info("ObtainListPriceExecuter ObtainListPriceV3 requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getObtainListPriceUrl(), requestData);
        log.info("ObtainListPriceExecuter ObtainListPriceV3 responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        String status = responseData.getString(Constants.STATUS);
        if (Constants.ERROR.equals(status)) {
            throw new ResponseException(responseData);
        }
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        log.info("ObtainListPriceExecuter ObtainListPriceV3 responseStr:[" + responseData + "]");
        this.bothVerifyHmacOrder(responseData);
        if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }
}

