/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.jointaccount.v_2.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import org.apache.commons.lang3.StringUtils;

public class JointSettlementProfileQueryBuilder
extends BuilderSupport {
    private String merchantId;
    private String jointNumber;
    private String minAmount;
    private String bankAccountNo;
    private String name;
    private String bankCode;
    private String bankName;
    private String accountType;
    private String provinceCode;
    private String cityCode;
    private String branchBankName;

    public JointSettlementProfileQueryBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public JointSettlementProfileQueryBuilder setJointNumber(String jointNumber) {
        this.jointNumber = jointNumber;
        return this;
    }

    public JointSettlementProfileQueryBuilder setMinAmount(String minAmount) {
        this.minAmount = minAmount;
        return this;
    }

    public JointSettlementProfileQueryBuilder setBankAccountNo(String bankAccountNo) {
        this.bankAccountNo = bankAccountNo;
        return this;
    }

    public JointSettlementProfileQueryBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public JointSettlementProfileQueryBuilder setBankCode(String bankCode) {
        this.bankCode = bankCode;
        return this;
    }

    public JointSettlementProfileQueryBuilder setBankName(String bankName) {
        this.bankName = bankName;
        return this;
    }

    public JointSettlementProfileQueryBuilder setAccountType(String accountType) {
        this.accountType = accountType;
        return this;
    }

    public JointSettlementProfileQueryBuilder setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
        return this;
    }

    public JointSettlementProfileQueryBuilder setCityCode(String cityCode) {
        this.cityCode = cityCode;
        return this;
    }

    public JointSettlementProfileQueryBuilder setBranchBankName(String branchBankName) {
        this.branchBankName = branchBankName;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.jointNumber)) {
            json.put("jointNumber", (Object)this.jointNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)this.minAmount)) {
            json.put("minAmount", (Object)this.minAmount);
        }
        if (StringUtils.isNotBlank((CharSequence)this.bankAccountNo)) {
            json.put("bankAccountNo", (Object)this.bankAccountNo);
        }
        if (StringUtils.isNotBlank((CharSequence)this.name)) {
            json.put("name", (Object)this.name);
        }
        if (StringUtils.isNotBlank((CharSequence)this.bankCode)) {
            json.put("bankCode", (Object)this.bankCode);
        }
        if (StringUtils.isNotBlank((CharSequence)this.bankName)) {
            json.put("bankName", (Object)this.bankName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.accountType)) {
            json.put("accountType", (Object)this.accountType);
        }
        if (StringUtils.isNotBlank((CharSequence)this.provinceCode)) {
            json.put("provinceCode", (Object)this.provinceCode);
        }
        if (StringUtils.isNotBlank((CharSequence)this.cityCode)) {
            json.put("cityCode", (Object)this.cityCode);
        }
        if (StringUtils.isNotBlank((CharSequence)this.branchBankName)) {
            json.put("branchBankName", (Object)this.branchBankName);
        }
        return json;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(this.merchantId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }
}

