/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.foreignpayExchangesettlement.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.foreignpayExchangesettlement.builder.Payer;
import com.upay.sdk.foreignpayExchangesettlement.builder.ProductDetailRequest;
import java.util.List;

public class ForeignpayExchangesettlementOrderV3Builder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String amount;
    private String currency;
    private String forUse;
    private String notifyUrl;
    private String remark;
    private String paymentModeCode;
    private String timeout;
    private List<ProductDetailRequest> productDetails;
    private Payer payer;

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(this.merchantId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getAmount() {
        return this.amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getForUse() {
        return this.forUse;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getPaymentModeCode() {
        return this.paymentModeCode;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public List<ProductDetailRequest> getProductDetails() {
        return this.productDetails;
    }

    public Payer getPayer() {
        return this.payer;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void setForUse(String forUse) {
        this.forUse = forUse;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setPaymentModeCode(String paymentModeCode) {
        this.paymentModeCode = paymentModeCode;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public void setProductDetails(List<ProductDetailRequest> productDetails) {
        this.productDetails = productDetails;
    }

    public void setPayer(Payer payer) {
        this.payer = payer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ForeignpayExchangesettlementOrderV3Builder)) {
            return false;
        }
        ForeignpayExchangesettlementOrderV3Builder other = (ForeignpayExchangesettlementOrderV3Builder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$merchantId = this.getMerchantId();
        String other$merchantId = other.getMerchantId();
        if (this$merchantId == null ? other$merchantId != null : !this$merchantId.equals(other$merchantId)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        String this$amount = this.getAmount();
        String other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$forUse = this.getForUse();
        String other$forUse = other.getForUse();
        if (this$forUse == null ? other$forUse != null : !this$forUse.equals(other$forUse)) {
            return false;
        }
        String this$notifyUrl = this.getNotifyUrl();
        String other$notifyUrl = other.getNotifyUrl();
        if (this$notifyUrl == null ? other$notifyUrl != null : !this$notifyUrl.equals(other$notifyUrl)) {
            return false;
        }
        String this$remark = this.getRemark();
        String other$remark = other.getRemark();
        if (this$remark == null ? other$remark != null : !this$remark.equals(other$remark)) {
            return false;
        }
        String this$paymentModeCode = this.getPaymentModeCode();
        String other$paymentModeCode = other.getPaymentModeCode();
        if (this$paymentModeCode == null ? other$paymentModeCode != null : !this$paymentModeCode.equals(other$paymentModeCode)) {
            return false;
        }
        String this$timeout = this.getTimeout();
        String other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !this$timeout.equals(other$timeout)) {
            return false;
        }
        List<ProductDetailRequest> this$productDetails = this.getProductDetails();
        List<ProductDetailRequest> other$productDetails = other.getProductDetails();
        if (this$productDetails == null ? other$productDetails != null : !((Object)this$productDetails).equals(other$productDetails)) {
            return false;
        }
        Payer this$payer = this.getPayer();
        Payer other$payer = other.getPayer();
        return !(this$payer == null ? other$payer != null : !((Object)this$payer).equals(other$payer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ForeignpayExchangesettlementOrderV3Builder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $merchantId = this.getMerchantId();
        result = result * 59 + ($merchantId == null ? 43 : $merchantId.hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        String $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : $amount.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $forUse = this.getForUse();
        result = result * 59 + ($forUse == null ? 43 : $forUse.hashCode());
        String $notifyUrl = this.getNotifyUrl();
        result = result * 59 + ($notifyUrl == null ? 43 : $notifyUrl.hashCode());
        String $remark = this.getRemark();
        result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
        String $paymentModeCode = this.getPaymentModeCode();
        result = result * 59 + ($paymentModeCode == null ? 43 : $paymentModeCode.hashCode());
        String $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : $timeout.hashCode());
        List<ProductDetailRequest> $productDetails = this.getProductDetails();
        result = result * 59 + ($productDetails == null ? 43 : ((Object)$productDetails).hashCode());
        Payer $payer = this.getPayer();
        result = result * 59 + ($payer == null ? 43 : ((Object)$payer).hashCode());
        return result;
    }

    public String toString() {
        return "ForeignpayExchangesettlementOrderV3Builder(merchantId=" + this.getMerchantId() + ", requestId=" + this.getRequestId() + ", amount=" + this.getAmount() + ", currency=" + this.getCurrency() + ", forUse=" + this.getForUse() + ", notifyUrl=" + this.getNotifyUrl() + ", remark=" + this.getRemark() + ", paymentModeCode=" + this.getPaymentModeCode() + ", timeout=" + this.getTimeout() + ", productDetails=" + this.getProductDetails() + ", payer=" + this.getPayer() + ")";
    }
}

