/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.declaration.v_3.subMerchant.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.entity.SubMerchantCertificate;
import com.upay.sdk.entity.SubMerchantRiskDoc;
import com.upay.sdk.exception.UnknownException;
import java.util.LinkedList;
import java.util.List;

public final class SubMerchantDeclareBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String operationType;
    private String subMerchantId;
    private String signedName;
    private String email;
    private String phone;
    private String businessScope;
    private String authUserId;
    private String authEnterpriseId;
    private String hasAgreeProtocol;
    private String notifyUrl;
    private SubMerchantCertificate declarationSubMerchantCertificate;
    private List<SubMerchantRiskDoc> declarationSubMerchantRiskDocs = new LinkedList<SubMerchantRiskDoc>();

    public SubMerchantDeclareBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(this.merchantId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    public SubMerchantDeclareBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public SubMerchantDeclareBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public SubMerchantDeclareBuilder setOperationType(String operationType) {
        this.operationType = operationType;
        return this;
    }

    public SubMerchantDeclareBuilder setSubMerchantId(String subMerchantId) {
        this.subMerchantId = subMerchantId;
        return this;
    }

    public SubMerchantDeclareBuilder setSignedName(String signedName) {
        this.signedName = signedName;
        return this;
    }

    public SubMerchantDeclareBuilder setEmail(String email) {
        this.email = email;
        return this;
    }

    public SubMerchantDeclareBuilder setPhone(String phone) {
        this.phone = phone;
        return this;
    }

    public SubMerchantDeclareBuilder setBusinessScope(String businessScope) {
        this.businessScope = businessScope;
        return this;
    }

    public SubMerchantDeclareBuilder setAuthUserId(String authUserId) {
        this.authUserId = authUserId;
        return this;
    }

    public SubMerchantDeclareBuilder setAuthEnterpriseId(String authEnterpriseId) {
        this.authEnterpriseId = authEnterpriseId;
        return this;
    }

    public SubMerchantDeclareBuilder setHasAgreeProtocol(String hasAgreeProtocol) {
        this.hasAgreeProtocol = hasAgreeProtocol;
        return this;
    }

    public SubMerchantDeclareBuilder setDeclarationSubMerchantCertificate(SubMerchantCertificate declarationSubMerchantCertificate) {
        this.declarationSubMerchantCertificate = declarationSubMerchantCertificate;
        return this;
    }

    public SubMerchantDeclareBuilder addDeclarationSubMerchantRiskDoc(SubMerchantRiskDoc subMerchantRiskDoc) {
        this.declarationSubMerchantRiskDocs.add(subMerchantRiskDoc);
        return this;
    }

    public SubMerchantDeclareBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }
}

