/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.currencyexchange.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;
import java.math.BigDecimal;

public class WithdrawPayBuilder
extends BuilderSupport {
    private String requestNo;
    private String merchantId;
    private String type;
    private String accountId;
    private String currency;
    private String feeCharge;
    private BigDecimal feeAmount;
    private String useage;
    private String amount;
    private String postscript;
    private String filePath;
    private String fileName;
    private String callBackUrl;
    private String userName;

    public WithdrawPayBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public WithdrawPayBuilder setRequestNo(String requestNo) {
        this.requestNo = requestNo;
        return this;
    }

    public WithdrawPayBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public WithdrawPayBuilder setType(String type) {
        this.type = type;
        return this;
    }

    public WithdrawPayBuilder setAccountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    public WithdrawPayBuilder setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public WithdrawPayBuilder setFeeCharge(String feeCharge) {
        this.feeCharge = feeCharge;
        return this;
    }

    public WithdrawPayBuilder setFeeAmount(BigDecimal feeAmount) {
        this.feeAmount = feeAmount;
        return this;
    }

    public WithdrawPayBuilder setUseage(String useage) {
        this.useage = useage;
        return this;
    }

    public WithdrawPayBuilder setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public WithdrawPayBuilder setPostscript(String postscript) {
        this.postscript = postscript;
        return this;
    }

    public WithdrawPayBuilder setFilePath(String filePath) {
        this.filePath = filePath;
        return this;
    }

    public WithdrawPayBuilder setFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public WithdrawPayBuilder setCallBackUrl(String callBackUrl) {
        this.callBackUrl = callBackUrl;
        return this;
    }

    public String getRequestNo() {
        return this.requestNo;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public String getType() {
        return this.type;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getFeeCharge() {
        return this.feeCharge;
    }

    public BigDecimal getFeeAmount() {
        return this.feeAmount;
    }

    public String getUseage() {
        return this.useage;
    }

    public String getAmount() {
        return this.amount;
    }

    public String getPostscript() {
        return this.postscript;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getCallBackUrl() {
        return this.callBackUrl;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

