/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.currencyexchange.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;

public class ReceivePaymentAccountBuilder
extends BuilderSupport {
    private String merchantId;
    private String accountType;
    private String bankName;
    private String bankAddress;
    private String swift;
    private String accountName;
    private String accountNo;
    private String payeeAddress;
    private String currency;

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public String getBankName() {
        return this.bankName;
    }

    public String getBankAddress() {
        return this.bankAddress;
    }

    public String getSwift() {
        return this.swift;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getAccountNo() {
        return this.accountNo;
    }

    public String getPayeeAddress() {
        return this.payeeAddress;
    }

    public String getCurrency() {
        return this.currency;
    }

    public ReceivePaymentAccountBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public ReceivePaymentAccountBuilder setAccountType(String accountType) {
        this.accountType = accountType;
        return this;
    }

    public ReceivePaymentAccountBuilder setBankName(String bankName) {
        this.bankName = bankName;
        return this;
    }

    public ReceivePaymentAccountBuilder setBankAddress(String bankAddress) {
        this.bankAddress = bankAddress;
        return this;
    }

    public ReceivePaymentAccountBuilder setSwift(String swift) {
        this.swift = swift;
        return this;
    }

    public ReceivePaymentAccountBuilder setAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    public ReceivePaymentAccountBuilder setAccountNo(String accountNo) {
        this.accountNo = accountNo;
        return this;
    }

    public ReceivePaymentAccountBuilder setPayeeAddress(String payeeAddress) {
        this.payeeAddress = payeeAddress;
        return this;
    }

    public ReceivePaymentAccountBuilder setCurrency(String currency) {
        this.currency = currency;
        return this;
    }
}

