/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.currencyexchange.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;

public class QueryAccountFlowBuilder
extends BuilderSupport {
    private String merchantId;
    private String currency;
    private String createStartDateTime;
    private String createEndDateTime;

    public QueryAccountFlowBuilder(String merchantId, String currency, String createStartDateTime, String createEndDateTime) {
        this.merchantId = merchantId;
        this.currency = currency;
        this.createStartDateTime = createStartDateTime;
        this.createEndDateTime = createEndDateTime;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    public QueryAccountFlowBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public QueryAccountFlowBuilder setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public QueryAccountFlowBuilder setCreateStartDateTime(String createStartDateTime) {
        this.createStartDateTime = createStartDateTime;
        return this;
    }

    public QueryAccountFlowBuilder setCreateEndDateTime(String createEndDateTime) {
        this.createEndDateTime = createEndDateTime;
        return this;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getCreateStartDateTime() {
        return this.createStartDateTime;
    }

    public String getCreateEndDateTime() {
        return this.createEndDateTime;
    }
}

