/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.core;

import com.upay.sdk.crypto.CertificateReader;
import com.upay.sdk.crypto.EncryptionAlgorithm;
import com.upay.sdk.crypto.SdkEncryptDecryptSupport;
import com.upay.sdk.crypto.exception.EncryptDecryptNotSupportException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;

public abstract class Environment {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final Map<EncryptionAlgorithm, SdkEncryptDecryptSupport> SDKENCRYPTDECRYPTSUPPORT_MAP = new ConcurrentHashMap<EncryptionAlgorithm, SdkEncryptDecryptSupport>();

    private static SdkEncryptDecryptSupport spiLoad(EncryptionAlgorithm encryptionAlgorithm) throws EncryptDecryptNotSupportException {
        ServiceLoader<SdkEncryptDecryptSupport> serviceLoader = ServiceLoader.load(SdkEncryptDecryptSupport.class);
        for (SdkEncryptDecryptSupport encryptDecryptSupport : serviceLoader) {
            if (!encryptDecryptSupport.isSupport(encryptionAlgorithm)) continue;
            return encryptDecryptSupport;
        }
        throw new EncryptDecryptNotSupportException(encryptionAlgorithm);
    }

    public static SdkEncryptDecryptSupport getSdkEncryptDecryptSupport(EncryptionAlgorithm encryptionAlgorithm) throws EncryptDecryptNotSupportException {
        if (encryptionAlgorithm == null) {
            throw new EncryptDecryptNotSupportException(null);
        }
        return SDKENCRYPTDECRYPTSUPPORT_MAP.computeIfAbsent(encryptionAlgorithm, Environment::spiLoad);
    }

    public static List<CertificateReader> getCertificateReaderList() {
        ArrayList<CertificateReader> readers = new ArrayList<CertificateReader>();
        ServiceLoader<CertificateReader> serviceLoader = ServiceLoader.load(CertificateReader.class);
        for (CertificateReader reader : serviceLoader) {
            readers.add(reader);
        }
        if (readers.isEmpty()) {
            throw new IllegalStateException("not found CertificateReader impl,please check upay-sdk-sm.jar or upay-sdk-international.jar");
        }
        return readers;
    }
}

