/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.webox.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;
import org.apache.commons.lang3.StringUtils;

public final class MerchantRechargeBatchBuilder
extends BuilderSupport {
    private String merchantId;
    private String partnerId;
    private String requestId;
    private String walletId;
    private String amount;
    private String currency;
    private String notifyUrl;
    private String remark;

    public MerchantRechargeBatchBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public MerchantRechargeBatchBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public MerchantRechargeBatchBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public MerchantRechargeBatchBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public MerchantRechargeBatchBuilder setWalletId(String walletId) {
        this.walletId = walletId;
        return this;
    }

    public MerchantRechargeBatchBuilder setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public MerchantRechargeBatchBuilder setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public MerchantRechargeBatchBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public MerchantRechargeBatchBuilder setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(StringUtils.isBlank((CharSequence)this.partnerId) ? this.merchantId : this.partnerId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        return SignUtils.signMd5(orderGenerateHmac, ConfigurationUtils.getHmacKey(StringUtils.isBlank((CharSequence)this.partnerId) ? this.merchantId : this.partnerId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

