/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.wallet.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;
import org.apache.commons.lang3.StringUtils;

public final class WithdrawBuilder
extends BuilderSupport {
    private String merchantId;
    private String partnerId;
    private String requestId;
    private String withdrawAmount;
    private String notifyUrl;
    private String remark;
    private String deputeMark;
    private String receivedAmount;

    public WithdrawBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public WithdrawBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public WithdrawBuilder setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    public WithdrawBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public WithdrawBuilder setWithdrawAmount(String withdrawAmount) {
        this.withdrawAmount = withdrawAmount;
        return this;
    }

    public WithdrawBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public WithdrawBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public WithdrawBuilder setDeputeMark(String deputeMark) {
        this.deputeMark = deputeMark;
        return this;
    }

    public void setReceivedAmount(String receivedAmount) {
        this.receivedAmount = receivedAmount;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            json.put("partnerId", (Object)this.partnerId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.withdrawAmount)) {
            json.put("withdrawAmount", (Object)this.withdrawAmount);
        }
        if (StringUtils.isNotBlank((CharSequence)this.notifyUrl)) {
            json.put("notifyUrl", (Object)this.notifyUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)this.remark)) {
            json.put("remark", (Object)this.remark);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.requestId)).append(StringUtils.defaultString((String)this.partnerId)).append(StringUtils.defaultString((String)this.withdrawAmount)).append(StringUtils.defaultString((String)this.notifyUrl)).append(StringUtils.defaultString((String)this.remark));
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.partnerId));
        }
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.encryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.partnerId));
        }
        return SignUtils.signMd5(orderGenerateHmac, ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

