/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.sjtTransfer.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.entity.SJTTransferInfo;
import com.upay.sdk.exception.UnknownException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class OrderBuilder
extends BuilderSupport {
    private String merchantId;
    private String taxMerchantId;
    private String transferMerchantId;
    private String batchRequestId;
    private String notifyUrl;
    private String remark;
    private String partnerId;
    private String timeout;
    private String needKaptcha;
    private String profit;
    private List<SJTTransferInfo> transferInfos = new LinkedList<SJTTransferInfo>();

    public OrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public OrderBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public String getTaxMerchantId() {
        return this.taxMerchantId;
    }

    public OrderBuilder setTaxMerchantId(String taxMerchantId) {
        this.taxMerchantId = taxMerchantId;
        return this;
    }

    public String getTransferMerchantId() {
        return this.transferMerchantId;
    }

    public OrderBuilder setTransferMerchantId(String transferMerchantId) {
        this.transferMerchantId = transferMerchantId;
        return this;
    }

    public OrderBuilder setBatchRequestId(String batchRequestId) {
        this.batchRequestId = batchRequestId;
        return this;
    }

    public String getBatchRequestId() {
        return this.batchRequestId;
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public OrderBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public OrderBuilder setTimeout(String timeout) {
        this.timeout = timeout;
        return this;
    }

    public String getNeedKaptcha() {
        return this.needKaptcha;
    }

    public OrderBuilder setNeedKaptcha(String needKaptcha) {
        this.needKaptcha = needKaptcha;
        return this;
    }

    public String getProfit() {
        return this.profit;
    }

    public OrderBuilder setProfit(String profit) {
        this.profit = profit;
        return this;
    }

    public String getRemark() {
        return this.remark;
    }

    public OrderBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public OrderBuilder addTransferInfos(SJTTransferInfo transferInfos) {
        this.transferInfos.add(transferInfos);
        return this;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

