/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.serviceprovider.v3_0.declaration.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.serviceprovider.v3_0.declaration.builder.QuerySuccessSecondaryReportBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuerySuccessSecondaryReportExecuter
extends Executer {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuerySuccessSecondaryReportExecuter.class);

    public void query(QuerySuccessSecondaryReportBuilder builder, ResultListener resultListener) {
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.info("QuerySuccessSecondaryReportExecuter requestData:[{}]", (Object)requestData.toJSONString());
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getServiceProviderQuerySuccessSecondaryReportUrl(), requestData);
            LOGGER.info("QuerySuccessSecondaryReportExecuter responseStr :{}", (Object)responseStr);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            responseData = CipherWrapper.bothDecryptWrap(responseData);
            LOGGER.info("QuerySuccessSecondaryReportExecuter responseStr:[{}]", (Object)responseData);
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                throw new ResponseException(responseData);
            }
            this.bothVerifyHmacOrder(responseData);
            if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                throw new ResponseException(responseData);
            }
            resultListener.success(responseData);
        }
        catch (Exception e) {
            LOGGER.error("QuerySuccessSecondaryReportExecuter request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }
}

