/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.serviceprovider.v3_0.declaration.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;
import org.apache.commons.lang3.StringUtils;

public class UndoOpenAccountIntendConfirmApplyBuilder
extends BuilderSupport {
    private String partnerId;
    private String merchantId;
    private String requestId;
    private String applyRequestId;
    private String channelType;

    public UndoOpenAccountIntendConfirmApplyBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getApplyRequestId() {
        return this.applyRequestId;
    }

    public UndoOpenAccountIntendConfirmApplyBuilder setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    public UndoOpenAccountIntendConfirmApplyBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public UndoOpenAccountIntendConfirmApplyBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public UndoOpenAccountIntendConfirmApplyBuilder setApplyRequestId(String applyRequestId) {
        this.applyRequestId = applyRequestId;
        return this;
    }

    public String getChannelType() {
        return this.channelType;
    }

    public UndoOpenAccountIntendConfirmApplyBuilder setChannelType(String channelType) {
        this.channelType = channelType;
        return this;
    }
}

