/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.serviceprovider.v3_0.declaration.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;
import org.apache.commons.lang3.StringUtils;

public class SubMerchantBalanceBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String currency;
    private String dateTime;
    private String partnerId;
    private String accountType;

    public SubMerchantBalanceBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public SubMerchantBalanceBuilder setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public SubMerchantBalanceBuilder setDateTime(String dateTime) {
        this.dateTime = dateTime;
        return this;
    }

    public SubMerchantBalanceBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public SubMerchantBalanceBuilder setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    public SubMerchantBalanceBuilder setAccountType(String accountType) {
        this.accountType = accountType;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.currency)) {
            json.put("currency", (Object)this.currency);
        }
        if (StringUtils.isNotBlank((CharSequence)this.dateTime)) {
            json.put("dateTime", (Object)this.dateTime);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            json.put("partnerId", (Object)this.partnerId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.accountType)) {
            json.put("accountType", (Object)this.accountType);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.requestId, (String)"")).append(StringUtils.defaultString((String)this.currency, (String)"")).append(StringUtils.defaultString((String)this.dateTime, (String)"")).append(StringUtils.defaultString((String)this.partnerId, (String)"")).append(StringUtils.defaultString((String)this.accountType, (String)""));
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.partnerId));
        }
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.encryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    public JSONObject build(String merchantId) {
        return super.build(merchantId);
    }

    @Override
    protected JSONObject assembleBuild() {
        return super.assembleBuild();
    }

    @Override
    protected String orderGenerateHmac() {
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.partnerId));
        }
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        System.out.println("super.orderGenerateHmac() = " + super.orderGenerateHmac());
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

