/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.serviceprovider.v3_0.declaration.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.serviceprovider.v3_0.declaration.entity.ContactInfo;
import com.upay.sdk.serviceprovider.v3_0.declaration.entity.LegalPersonInfo;

public class PreDeclarationBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String registerRole;
    private String sendActiveEmail;
    private String notifyUrl;
    private String productPackage;
    private LegalPersonInfo legalPersonInfo;
    private ContactInfo contactInfo;

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getRegisterRole() {
        return this.registerRole;
    }

    public void setRegisterRole(String registerRole) {
        this.registerRole = registerRole;
    }

    public String getSendActiveEmail() {
        return this.sendActiveEmail;
    }

    public void setSendActiveEmail(String sendActiveEmail) {
        this.sendActiveEmail = sendActiveEmail;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getProductPackage() {
        return this.productPackage;
    }

    public void setProductPackage(String productPackage) {
        this.productPackage = productPackage;
    }

    public LegalPersonInfo getLegalPersonInfo() {
        return this.legalPersonInfo;
    }

    public void setLegalPersonInfo(LegalPersonInfo legalPersonInfo) {
        this.legalPersonInfo = legalPersonInfo;
    }

    public ContactInfo getContactInfo() {
        return this.contactInfo;
    }

    public void setContactInfo(ContactInfo contactInfo) {
        this.contactInfo = contactInfo;
    }
}

