/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.rz.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.rz.builder.RzOrderBuilder;
import com.upay.sdk.rz.builder.RzQueryBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RzOrderExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(RzOrderExecuter.class);
    static final String[] ORDER_RESPONSE_HMAC_FIELDS = new String[]{Constants.MERCHANT_ID, Constants.REQUEST_ID, Constants.SERIAL_NUMBER, Constants.AUTH_TYPE, Constants.NAME, Constants.ID_CARD_NUM, Constants.BANK_CARD_NUMBER, Constants.PHONE_NUMBER, Constants.STATUS, Constants.PHOTO};
    static final String[] QUERY_RESPONSE_HMAC_FIELDS = new String[]{Constants.MERCHANT_ID, Constants.REQUEST_ID, Constants.SERIAL_NUMBER, Constants.AUTH_TYPE, Constants.NAME, Constants.ID_CARD_NUM, Constants.BANK_CARD_NUMBER, Constants.PHONE_NUMBER, Constants.STATUS, Constants.PHOTO};

    public void order(JSONObject requestData, ResultListener resultListener) {
        LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post(ConfigurationUtils.getRzOrderUrl(), requestData.toJSONString());
        LOGGER.debug("responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        this.verifyHmac(ORDER_RESPONSE_HMAC_FIELDS, responseData);
        if (StringUtils.isBlank((CharSequence)responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void query(JSONObject requestData, ResultListener resultListener) {
        LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post(ConfigurationUtils.getRzQueryUrl(), requestData.toJSONString());
        LOGGER.debug("responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        this.verifyHmac(QUERY_RESPONSE_HMAC_FIELDS, responseData);
        if (StringUtils.isBlank((CharSequence)responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void order(RzOrderBuilder builder, ResultListener resultListener) {
        try {
            JSONObject requestData = builder.encryptBuild();
            String responseStr = HttpClientUtils.post2(ConfigurationUtils.getRzOrderUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            responseData = CipherWrapper.decryptWrap(responseData);
            LOGGER.debug("responseStr:[" + responseData + "]");
            this.verifyHmacOrder(responseData);
            if (StringUtils.isBlank((CharSequence)responseData.getString(Constants.STATUS))) {
                throw new ResponseException(responseData);
            }
            resultListener.success(responseData);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void query(RzQueryBuilder builder, ResultListener resultListener) {
        try {
            JSONObject requestData = builder.encryptBuild();
            LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getRzQueryUrl(), requestData);
            LOGGER.debug("responseStr:[" + responseStr + "]");
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            responseData = CipherWrapper.decryptWrap(responseData);
            this.verifyHmacOrder(responseData);
            if (StringUtils.isBlank((CharSequence)responseData.getString(Constants.STATUS))) {
                throw new ResponseException(responseData);
            }
            resultListener.success(responseData);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void bothOrder(RzOrderBuilder builder, ResultListener resultListener) {
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getRzOrderUrl(), requestData);
        LOGGER.debug("responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        this.bothVerifyHmacOrder(responseData);
        if (StringUtils.isBlank((CharSequence)responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }

    public void bothQuery(RzQueryBuilder builder, ResultListener resultListener) {
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getRzQueryUrl(), requestData);
        LOGGER.debug("responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        this.bothVerifyHmacOrder(responseData);
        if (StringUtils.isBlank((CharSequence)responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }
}

