/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.rz.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.rz.builder.CreditQueryOrderBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreditQueryOrderExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(CreditQueryOrderExecuter.class);

    public void order(CreditQueryOrderBuilder builder, ResultListener resultListener) {
        try {
            JSONObject requestData = builder.encryptBuild();
            String responseStr = HttpClientUtils.post2(ConfigurationUtils.getCreditQueryOrderUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            responseData = CipherWrapper.decryptWrap(responseData);
            LOGGER.debug("responseStr:[" + responseData + "]");
            this.verifyHmacOrder(responseData);
            if (StringUtils.isBlank((CharSequence)responseData.getString(Constants.STATUS))) {
                throw new ResponseException(responseData);
            }
            resultListener.success(responseData);
        }
        catch (Exception e) {
            LOGGER.error("request order exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void bothOrder(CreditQueryOrderBuilder builder, ResultListener resultListener) {
        LOGGER.debug("bothOrder begin ........");
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getCreditQueryOrderUrl(), requestData);
        LOGGER.debug("responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
        responseData = CipherWrapper.bothDecryptWrap(responseData);
        this.bothVerifyHmacOrder(responseData);
        if (StringUtils.isBlank((CharSequence)responseData.getString(Constants.STATUS))) {
            throw new ResponseException(responseData);
        }
        resultListener.success(responseData);
    }
}

