/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.prepaycard.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import org.apache.commons.lang3.StringUtils;

public class DestroyCardQueryBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String cardNo;
    private String cardType;

    public DestroyCardQueryBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public DestroyCardQueryBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public DestroyCardQueryBuilder setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public DestroyCardQueryBuilder setCardType(String cardType) {
        this.cardType = cardType;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.cardNo)) {
            json.put("cardNo", (Object)this.cardNo);
        }
        if (StringUtils.isNotBlank((CharSequence)this.cardType)) {
            json.put("cardType", (Object)this.cardType);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.requestId)).append(StringUtils.defaultString((String)this.cardType)).append(StringUtils.defaultString((String)this.cardNo));
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }
}

