/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.phoenix.v_1.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.phoenix.v_1.builder.ReportBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(ReportExecuter.class);

    public void report(ReportBuilder builder, ResultListener resultListener) {
        block5: {
            try {
                JSONObject requestData = builder.encryptBuild();
                LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
                String phoenixReportUrl = ConfigurationUtils.getPhoenixReportUrl();
                String responseStr = HttpClientUtils.post2(phoenixReportUrl, requestData);
                LOGGER.info("responseStr:" + responseStr);
                JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                responseData = CipherWrapper.decryptWrap(responseData);
                LOGGER.debug("responseStr:[" + responseData + "]");
                this.verifyHmacOrder(responseData);
                status = responseData.getString(Constants.STATUS);
                LOGGER.debug("status:[{}]", (Object)status);
                if (Constants.SUCCESS.equals(status)) {
                    LOGGER.debug("invoke success");
                    resultListener.success(responseData);
                    break block5;
                }
                if (Constants.FAILED.equals(status)) {
                    LOGGER.debug("invoke failure");
                    resultListener.failure(responseData);
                    break block5;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("request report exception", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }
}

