/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.phoenix.v_1.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import org.apache.commons.lang3.StringUtils;

public final class BindCardBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String bankCardType;
    private String bankCardNumber;
    private String idCardNum;
    private String phoneNumber;
    private String bankCode;
    private String name;
    private String bankCardExpireYear;
    private String bankCardExpireMonth;
    private String bankCardCvv;

    public String getBankCardType() {
        return this.bankCardType;
    }

    public BindCardBuilder setBankCardType(String bankCardType) {
        this.bankCardType = bankCardType;
        return this;
    }

    public String getBankCardNumber() {
        return this.bankCardNumber;
    }

    public BindCardBuilder setBankCardNumber(String bankCardNumber) {
        this.bankCardNumber = bankCardNumber;
        return this;
    }

    public String getIdCardNum() {
        return this.idCardNum;
    }

    public BindCardBuilder setIdCardNum(String idCardNum) {
        this.idCardNum = idCardNum;
        return this;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public BindCardBuilder setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    public String getBankCode() {
        return this.bankCode;
    }

    public BindCardBuilder setBankCode(String bankCode) {
        this.bankCode = bankCode;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public BindCardBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public String getBankCardExpireYear() {
        return this.bankCardExpireYear;
    }

    public BindCardBuilder setBankCardExpireYear(String bankCardExpireYear) {
        this.bankCardExpireYear = bankCardExpireYear;
        return this;
    }

    public String getBankCardExpireMonth() {
        return this.bankCardExpireMonth;
    }

    public BindCardBuilder setBankCardExpireMonth(String bankCardExpireMonth) {
        this.bankCardExpireMonth = bankCardExpireMonth;
        return this;
    }

    public String getBankCardCvv() {
        return this.bankCardCvv;
    }

    public BindCardBuilder setBankCardCvv(String bankCardCvv) {
        this.bankCardCvv = bankCardCvv;
        return this;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public BindCardBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public BindCardBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public BindCardBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.bankCardType)) {
            json.put("bankCardType", (Object)this.bankCardType);
        }
        if (StringUtils.isNotBlank((CharSequence)this.bankCardNumber)) {
            json.put("bankCardNumber", (Object)this.bankCardNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)this.idCardNum)) {
            json.put("idCardNum", (Object)this.idCardNum);
        }
        if (StringUtils.isNotBlank((CharSequence)this.phoneNumber)) {
            json.put("phoneNumber", (Object)this.phoneNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)this.bankCode)) {
            json.put("bankCode", (Object)this.bankCode);
        }
        if (StringUtils.isNotBlank((CharSequence)this.name)) {
            json.put("name", (Object)this.name);
        }
        if (StringUtils.isNotBlank((CharSequence)this.bankCardExpireYear)) {
            json.put("bankCardExpireYear", (Object)this.bankCardExpireYear);
        }
        if (StringUtils.isNotBlank((CharSequence)this.bankCardExpireMonth)) {
            json.put("bankCardExpireMonth", (Object)this.bankCardExpireMonth);
        }
        if (StringUtils.isNotBlank((CharSequence)this.bankCardCvv)) {
            json.put("bankCardCvv", (Object)this.bankCardCvv);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.requestId)).append(StringUtils.defaultString((String)this.bankCardType)).append(StringUtils.defaultString((String)this.bankCardNumber)).append(StringUtils.defaultString((String)this.idCardNum)).append(StringUtils.defaultString((String)this.phoneNumber)).append(StringUtils.defaultString((String)this.bankCode)).append(StringUtils.defaultString((String)this.name)).append(StringUtils.defaultString((String)this.bankCardExpireYear)).append(StringUtils.defaultString((String)this.bankCardExpireMonth)).append(StringUtils.defaultString((String)this.bankCardCvv));
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(this.merchantId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }
}

