/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.listprice.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;

public class ObtainListPriceBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String sourceCurrency;
    private String targetCurrency;
    private String channel;
    private String dealtSide;

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(this.merchantId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getSourceCurrency() {
        return this.sourceCurrency;
    }

    public String getTargetCurrency() {
        return this.targetCurrency;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getDealtSide() {
        return this.dealtSide;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setSourceCurrency(String sourceCurrency) {
        this.sourceCurrency = sourceCurrency;
    }

    public void setTargetCurrency(String targetCurrency) {
        this.targetCurrency = targetCurrency;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public void setDealtSide(String dealtSide) {
        this.dealtSide = dealtSide;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObtainListPriceBuilder)) {
            return false;
        }
        ObtainListPriceBuilder other = (ObtainListPriceBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$merchantId = this.getMerchantId();
        String other$merchantId = other.getMerchantId();
        if (this$merchantId == null ? other$merchantId != null : !this$merchantId.equals(other$merchantId)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        String this$sourceCurrency = this.getSourceCurrency();
        String other$sourceCurrency = other.getSourceCurrency();
        if (this$sourceCurrency == null ? other$sourceCurrency != null : !this$sourceCurrency.equals(other$sourceCurrency)) {
            return false;
        }
        String this$targetCurrency = this.getTargetCurrency();
        String other$targetCurrency = other.getTargetCurrency();
        if (this$targetCurrency == null ? other$targetCurrency != null : !this$targetCurrency.equals(other$targetCurrency)) {
            return false;
        }
        String this$channel = this.getChannel();
        String other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
            return false;
        }
        String this$dealtSide = this.getDealtSide();
        String other$dealtSide = other.getDealtSide();
        return !(this$dealtSide == null ? other$dealtSide != null : !this$dealtSide.equals(other$dealtSide));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ObtainListPriceBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $merchantId = this.getMerchantId();
        result = result * 59 + ($merchantId == null ? 43 : $merchantId.hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        String $sourceCurrency = this.getSourceCurrency();
        result = result * 59 + ($sourceCurrency == null ? 43 : $sourceCurrency.hashCode());
        String $targetCurrency = this.getTargetCurrency();
        result = result * 59 + ($targetCurrency == null ? 43 : $targetCurrency.hashCode());
        String $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        String $dealtSide = this.getDealtSide();
        result = result * 59 + ($dealtSide == null ? 43 : $dealtSide.hashCode());
        return result;
    }

    public String toString() {
        return "ObtainListPriceBuilder(merchantId=" + this.getMerchantId() + ", requestId=" + this.getRequestId() + ", sourceCurrency=" + this.getSourceCurrency() + ", targetCurrency=" + this.getTargetCurrency() + ", channel=" + this.getChannel() + ", dealtSide=" + this.getDealtSide() + ")";
    }
}

