/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.jointaccount.v_3.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import com.upay.sdk.jointaccount.v_3.builder.NewRetailBindCardBuilder;
import com.upay.sdk.jointaccount.v_3.builder.NewRetailBindCardConfirmBuilder;
import com.upay.sdk.jointaccount.v_3.builder.NewRetailBindCardQueryBuilder;
import com.upay.sdk.jointaccount.v_3.builder.NewRetailBindCardUnbindBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewRetailBindCardExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(NewRetailBindCardExecuter.class);

    public void bindCard(NewRetailBindCardBuilder builder, ResultListener listener) {
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.info("bindCard requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getNewRetailBindCardUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            LOGGER.info("bindCard responseStr:[" + responseStr + "]");
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                LOGGER.info("bindCard decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            this.bothCipherCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("bindCard exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void bindCardConfirm(NewRetailBindCardConfirmBuilder builder, ResultListener listener) {
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.info("bindCardConfirm requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getNewRetailBindCardConfirmUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            LOGGER.info("bindCardConfirm responseStr:[" + responseStr + "]");
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                LOGGER.info("bindCardConfirm decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            this.bothCipherCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("bindCardConfirm exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void bindCardQuery(NewRetailBindCardQueryBuilder builder, ResultListener listener) {
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.info("bindCardQuery requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getNewRetailBindCardQueryUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            LOGGER.info("bindCardQuery responseStr:[" + responseStr + "]");
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                LOGGER.info("bindCardQuery decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            this.bothCipherCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("bindCardQuery exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void bindCardUnbind(NewRetailBindCardUnbindBuilder builder, ResultListener listener) {
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.info("bindCardUnbind requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getNewRetailUnBindCardUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            LOGGER.info("bindCardUnbind responseStr:[" + responseStr + "]");
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                LOGGER.info("bindCardUnbind decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            this.bothCipherCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("bindCardUnbind exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void bothCipherCallback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        this.bothVerifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        if (StringUtils.isNotBlank((CharSequence)status)) {
            if (Constants.SUCCESS.equals(status)) {
                listener.success(data);
            } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                listener.failure(data);
            } else if (Constants.INIT.equals(status)) {
                listener.pending(data);
            } else {
                throw new ResponseException(data);
            }
        }
    }
}

