/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.jointaccount.v_3.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;

public class NewRetailBindCardBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String idCardNumber;
    private String name;
    private String phoneNumber;
    private String bankCardNumber;

    public NewRetailBindCardBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public NewRetailBindCardBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public NewRetailBindCardBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public NewRetailBindCardBuilder setIdCardNumber(String idCardNumber) {
        this.idCardNumber = idCardNumber;
        return this;
    }

    public NewRetailBindCardBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public NewRetailBindCardBuilder setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    public NewRetailBindCardBuilder setBankCardNumber(String bankCardNumber) {
        this.bankCardNumber = bankCardNumber;
        return this;
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

