/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.icc.v_3.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.icc.v_3.entity.BillInfo;
import com.upay.sdk.icc.v_3.entity.ShipInfo;
import org.apache.commons.lang.StringUtils;

public class CashierOrderBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String orderAmount;
    private String orderCurrency;
    private String language;
    private String notifyUrl;
    private String callbackUrl;
    private String terminalNo;
    private String remark;
    private ShipInfo shipInfo;
    private BillInfo billInfo;
    private String partnerId;
    private String projectId;

    public CashierOrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public CashierOrderBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public CashierOrderBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public CashierOrderBuilder setOrderAmount(String orderAmount) {
        this.orderAmount = orderAmount;
        return this;
    }

    public CashierOrderBuilder setOrderCurrency(String orderCurrency) {
        this.orderCurrency = orderCurrency;
        return this;
    }

    public CashierOrderBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public CashierOrderBuilder setProjectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    public CashierOrderBuilder setTerminalNo(String terminalNo) {
        this.terminalNo = terminalNo;
        return this;
    }

    public CashierOrderBuilder setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public CashierOrderBuilder setLanguage(String language) {
        this.language = language;
        return this;
    }

    public CashierOrderBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public CashierOrderBuilder setShipInfo(ShipInfo shipInfo) {
        this.shipInfo = shipInfo;
        return this;
    }

    public CashierOrderBuilder setBillInfo(BillInfo billInfo) {
        this.billInfo = billInfo;
        return this;
    }

    public CashierOrderBuilder setPartnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(StringUtils.isBlank((String)this.partnerId) ? this.merchantId : this.partnerId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.partnerId)) {
            return CipherWrapper.bothEncryptWrap(this.merchantId, this.partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

