/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.foreignexchange.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.entity.BankCard;
import com.upay.sdk.entity.CustomsInfo;
import com.upay.sdk.entity.ExhibitionInfo;
import com.upay.sdk.entity.HotelInfo;
import com.upay.sdk.entity.LogisticsInfo;
import com.upay.sdk.entity.MeetingInfo;
import com.upay.sdk.entity.Payer;
import com.upay.sdk.entity.ProductDetail;
import com.upay.sdk.entity.SoftwareInfo;
import com.upay.sdk.entity.StudyAbroadInfo;
import com.upay.sdk.entity.SubOrder;
import com.upay.sdk.entity.TicketInfo;
import com.upay.sdk.entity.TravelInfo;
import com.upay.sdk.exception.UnknownException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public final class OrderBuilder
extends BuilderSupport {
    private String merchantId;
    private String orderAmount;
    private String orderCurrency;
    private String requestId;
    private String amount;
    private String currency;
    private String forUse;
    private String notifyUrl;
    private String callbackUrl;
    private String remark;
    private String paymentModeCode;
    private String openId;
    private String listPriceToken;
    private String cashierVersion;
    private String merchantUserId;
    private String bindCardId;
    private String clientIp;
    private String timeout;
    private String cbeVersion;
    private BankCard bankCard;
    private Payer payer;
    private StudyAbroadInfo studyAbroadInfo;
    private List<ProductDetail> productDetails = new LinkedList<ProductDetail>();
    private List<CustomsInfo> customsInfos = new LinkedList<CustomsInfo>();
    private List<SubOrder> subOrders = new LinkedList<SubOrder>();
    private List<TicketInfo> ticketInfos = new LinkedList<TicketInfo>();
    private List<HotelInfo> hotelInfos = new LinkedList<HotelInfo>();
    private List<TravelInfo> travelInfos = new LinkedList<TravelInfo>();
    private List<LogisticsInfo> logisticsInfos = new LinkedList<LogisticsInfo>();
    private SoftwareInfo softwareInfo;
    private MeetingInfo meetingInfo;
    private ExhibitionInfo exhibitionInfo;
    private String appId;
    private String fileName;

    public OrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public OrderBuilder setOrderAmount(String orderAmount) {
        this.orderAmount = orderAmount;
        return this;
    }

    public OrderBuilder setOrderCurrency(String orderCurrency) {
        this.orderCurrency = orderCurrency;
        return this;
    }

    public OrderBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public OrderBuilder setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public OrderBuilder setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public OrderBuilder setForUse(String forUse) {
        this.forUse = forUse;
        return this;
    }

    public OrderBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public OrderBuilder setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public OrderBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public OrderBuilder setPaymentModeCode(String paymentModeCode) {
        this.paymentModeCode = paymentModeCode;
        return this;
    }

    public OrderBuilder setPayer(Payer payer) {
        this.payer = payer;
        return this;
    }

    public void setListPriceToken(String listPriceToken) {
        this.listPriceToken = listPriceToken;
    }

    public void setProductDetails(List<ProductDetail> productDetails) {
        this.productDetails = productDetails;
    }

    public void setCustomsInfos(List<CustomsInfo> customsInfos) {
        this.customsInfos = customsInfos;
    }

    public void setTicketInfos(List<TicketInfo> ticketInfos) {
        this.ticketInfos = ticketInfos;
    }

    public void setHotelInfos(List<HotelInfo> hotelInfos) {
        this.hotelInfos = hotelInfos;
    }

    public void setSubOrders(List<SubOrder> subOrders) {
        this.subOrders = subOrders;
    }

    public OrderBuilder addProductDetail(ProductDetail productDetail) {
        this.productDetails.add(productDetail);
        return this;
    }

    public OrderBuilder addCustomsInfo(CustomsInfo customsInfo) {
        this.customsInfos.add(customsInfo);
        return this;
    }

    public OrderBuilder setTicketInfo(TicketInfo ticketInfo) {
        this.ticketInfos.add(ticketInfo);
        return this;
    }

    public OrderBuilder setHotelInfo(HotelInfo hotelInfo) {
        this.hotelInfos.add(hotelInfo);
        return this;
    }

    public OrderBuilder setTravelInfo(TravelInfo travelInfo) {
        this.travelInfos.add(travelInfo);
        return this;
    }

    public OrderBuilder setLogisticsInfo(LogisticsInfo logisticsInfo) {
        this.logisticsInfos.add(logisticsInfo);
        return this;
    }

    public OrderBuilder addSubOrder(SubOrder subOrder) {
        this.subOrders.add(subOrder);
        return this;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public void setCashierVersion(String cashierVersion) {
        this.cashierVersion = cashierVersion;
    }

    public void setCbeVersion(String cbeVersion) {
        this.cbeVersion = cbeVersion;
    }

    public void setMerchantUserId(String merchantUserId) {
        this.merchantUserId = merchantUserId;
    }

    public void setBindCardId(String bindCardId) {
        this.bindCardId = bindCardId;
    }

    public BankCard getBankCard() {
        return this.bankCard;
    }

    public void setBankCard(BankCard bankCard) {
        this.bankCard = bankCard;
    }

    public OrderBuilder setStudyAbroadInfo(StudyAbroadInfo studyAbroadInfo) {
        this.studyAbroadInfo = studyAbroadInfo;
        return this;
    }

    public OrderBuilder setSoftwareInfo(SoftwareInfo softwareInfo) {
        this.softwareInfo = softwareInfo;
        return this;
    }

    public OrderBuilder setMeetingInfo(MeetingInfo meetingInfo) {
        this.meetingInfo = meetingInfo;
        return this;
    }

    public OrderBuilder setExhibitionInfo(ExhibitionInfo exhibitionInfo) {
        this.exhibitionInfo = exhibitionInfo;
        return this;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public OrderBuilder setOpenId(String openId) {
        this.openId = openId;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.orderAmount)) {
            json.put("orderAmount", (Object)this.orderAmount);
        }
        if (StringUtils.isNotBlank((CharSequence)this.orderCurrency)) {
            json.put("orderCurrency", (Object)this.orderCurrency);
        }
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.amount)) {
            json.put("amount", (Object)this.amount);
        }
        if (StringUtils.isNotBlank((CharSequence)this.currency)) {
            json.put("currency", (Object)this.currency);
        }
        if (StringUtils.isNotBlank((CharSequence)this.forUse)) {
            json.put("forUse", (Object)this.forUse);
        }
        if (StringUtils.isNotBlank((CharSequence)this.notifyUrl)) {
            json.put("notifyUrl", (Object)this.notifyUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)this.callbackUrl)) {
            json.put("callbackUrl", (Object)this.callbackUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)this.remark)) {
            json.put("remark", (Object)this.remark);
        }
        if (StringUtils.isNotBlank((CharSequence)this.paymentModeCode)) {
            json.put("paymentModeCode", (Object)this.paymentModeCode);
        }
        if (StringUtils.isNotBlank((CharSequence)this.openId)) {
            json.put("openId", (Object)this.openId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.listPriceToken)) {
            json.put("listPriceToken", (Object)this.listPriceToken);
        }
        if (StringUtils.isNotBlank((CharSequence)this.cashierVersion)) {
            json.put("cashierVersion", (Object)this.cashierVersion);
        }
        if (StringUtils.isNotBlank((CharSequence)this.merchantUserId)) {
            json.put("merchantUserId", (Object)this.merchantUserId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.bindCardId)) {
            json.put("bindCardId", (Object)this.bindCardId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.clientIp)) {
            json.put("clientIp", (Object)this.clientIp);
        }
        if (StringUtils.isNotBlank((CharSequence)this.timeout)) {
            json.put("timeout", (Object)this.timeout);
        }
        if (StringUtils.isNotBlank((CharSequence)this.cbeVersion)) {
            json.put("cbeVersion", (Object)this.cbeVersion);
        }
        if (StringUtils.isNotBlank((CharSequence)this.appId)) {
            json.put("appId", (Object)this.appId);
        }
        json.put("productDetails", this.productDetails);
        json.put("customsInfos", this.customsInfos);
        json.put("payer", (Object)this.payer);
        json.put("bankCard", (Object)this.bankCard);
        json.put("studyAbroadInfo", (Object)this.studyAbroadInfo);
        json.put("softwareInfo", (Object)this.softwareInfo);
        json.put("meetingInfo", (Object)this.meetingInfo);
        json.put("exhibitionInfo", (Object)this.exhibitionInfo);
        json.put("subOrders", this.subOrders);
        json.put("ticketInfos", this.ticketInfos);
        json.put("hotelInfos", this.hotelInfos);
        json.put("travelInfos", this.travelInfos);
        json.put("logisticsInfos", this.logisticsInfos);
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append((String)ObjectUtils.defaultIfNull((Object)this.orderAmount, (Object)"")).append(StringUtils.defaultString((String)this.orderCurrency, (String)"")).append(StringUtils.defaultString((String)this.requestId, (String)"")).append((String)ObjectUtils.defaultIfNull((Object)this.amount, (Object)"")).append(StringUtils.defaultString((String)this.currency, (String)"")).append(StringUtils.defaultString((String)this.forUse, (String)"")).append(StringUtils.defaultString((String)this.listPriceToken, (String)"")).append(StringUtils.defaultString((String)this.notifyUrl, (String)"")).append(StringUtils.defaultString((String)this.callbackUrl, (String)"")).append(StringUtils.defaultString((String)this.remark, (String)"")).append(StringUtils.defaultString((String)this.paymentModeCode, (String)"")).append(StringUtils.defaultString((String)this.openId, (String)""));
        if (this.productDetails != null) {
            for (ProductDetail productDetail : this.productDetails) {
                hmacSource.append(StringUtils.defaultString((String)productDetail.getName())).append(ObjectUtils.defaultIfNull((Object)productDetail.getQuantity(), (Object)"")).append(ObjectUtils.defaultIfNull((Object)productDetail.getAmount(), (Object)"")).append(StringUtils.defaultString((String)productDetail.getReceiver())).append(StringUtils.defaultString((String)productDetail.getDescription()));
            }
        }
        if (this.payer != null) {
            hmacSource.append(StringUtils.defaultString((String)this.payer.getName())).append(StringUtils.defaultString((String)this.payer.getIdType())).append(StringUtils.defaultString((String)this.payer.getIdNum())).append(StringUtils.defaultString((String)this.payer.getBankCardNum())).append(StringUtils.defaultString((String)this.payer.getPhoneNum())).append(StringUtils.defaultString((String)this.payer.getEmail())).append(StringUtils.defaultString((String)this.payer.getNationality()));
        }
        if (this.customsInfos != null) {
            for (CustomsInfo customsInfo : this.customsInfos) {
                hmacSource.append(StringUtils.defaultString((String)customsInfo.getCustomsChannel())).append(ObjectUtils.defaultIfNull((Object)customsInfo.getAmount(), (Object)"")).append(ObjectUtils.defaultIfNull((Object)customsInfo.getGoodsAmount(), (Object)"")).append(ObjectUtils.defaultIfNull((Object)customsInfo.getTax(), (Object)"")).append(ObjectUtils.defaultIfNull((Object)customsInfo.getFreight(), (Object)""));
            }
        }
        hmacSource.append(StringUtils.defaultString((String)this.cashierVersion, (String)""));
        hmacSource.append(StringUtils.defaultString((String)this.merchantUserId, (String)""));
        hmacSource.append(StringUtils.defaultString((String)this.bindCardId, (String)""));
        if (this.bankCard != null) {
            hmacSource.append(StringUtils.defaultString((String)this.bankCard.getName())).append(StringUtils.defaultString((String)this.bankCard.getCardNo())).append(StringUtils.defaultString((String)this.bankCard.getCvv2())).append(StringUtils.defaultString((String)this.bankCard.getIdNo())).append(StringUtils.defaultString((String)this.bankCard.getExpiryDate())).append(StringUtils.defaultString((String)this.bankCard.getMobileNo()));
        }
        if (this.studyAbroadInfo != null) {
            hmacSource.append(StringUtils.defaultString((String)this.studyAbroadInfo.getSchoolName())).append(StringUtils.defaultString((String)this.studyAbroadInfo.getName())).append(StringUtils.defaultString((String)this.studyAbroadInfo.getStudentNumber())).append(StringUtils.defaultString((String)this.studyAbroadInfo.getSchoolWeb())).append(StringUtils.defaultString((String)this.studyAbroadInfo.getSchoolCity())).append(StringUtils.defaultString((String)this.studyAbroadInfo.getMajor())).append(StringUtils.defaultString((String)this.studyAbroadInfo.getAcademicDegree())).append(StringUtils.defaultString((String)this.studyAbroadInfo.getStudyAbroadTime()));
        }
        if (this.softwareInfo != null) {
            hmacSource.append(StringUtils.defaultString((String)this.softwareInfo.getSoftwareName())).append(StringUtils.defaultString((String)this.softwareInfo.getSoftwarePerson())).append(ObjectUtils.defaultIfNull((Object)this.softwareInfo.getSoftwareCount(), (Object)"")).append(StringUtils.defaultString((String)this.softwareInfo.getSoftwareDate())).append(StringUtils.defaultString((String)this.softwareInfo.getSoftwareWeb())).append(StringUtils.defaultString((String)this.softwareInfo.getSoftwareCode())).append(StringUtils.defaultString((String)this.softwareInfo.getSoftwareIp()));
        }
        if (this.meetingInfo != null) {
            hmacSource.append(StringUtils.defaultString((String)this.meetingInfo.getMeetingName())).append(StringUtils.defaultString((String)this.meetingInfo.getMeetingCountry())).append(StringUtils.defaultString((String)this.meetingInfo.getMeetingArea())).append(StringUtils.defaultString((String)this.meetingInfo.getMeetingPeople())).append(ObjectUtils.defaultIfNull((Object)this.meetingInfo.getMeetingCount(), (Object)"")).append(StringUtils.defaultString((String)this.meetingInfo.getMeetingStartDate())).append(StringUtils.defaultString((String)this.meetingInfo.getMeetingEndDate()));
        }
        if (this.exhibitionInfo != null) {
            hmacSource.append(StringUtils.defaultString((String)this.exhibitionInfo.getExhibitionName())).append(StringUtils.defaultString((String)this.exhibitionInfo.getExhibitionCountry())).append(StringUtils.defaultString((String)this.exhibitionInfo.getExhibitionArea())).append(StringUtils.defaultString((String)this.exhibitionInfo.getExhibitionPeople())).append(ObjectUtils.defaultIfNull((Object)this.exhibitionInfo.getExhibitionCount(), (Object)"")).append(StringUtils.defaultString((String)this.exhibitionInfo.getExhibitionStartDate())).append(StringUtils.defaultString((String)this.exhibitionInfo.getExhibitionEndDate()));
        }
        hmacSource.append(StringUtils.defaultString((String)this.clientIp, (String)""));
        hmacSource.append(StringUtils.defaultString((String)this.timeout, (String)""));
        if (this.subOrders != null) {
            for (SubOrder order : this.subOrders) {
                hmacSource.append(StringUtils.defaultString((String)order.getRequestId())).append(ObjectUtils.defaultIfNull((Object)order.getOrderAmount(), (Object)""));
            }
        }
        hmacSource.append(StringUtils.defaultString((String)this.cbeVersion, (String)""));
        if (this.ticketInfos != null) {
            for (TicketInfo ticketInfo : this.ticketInfos) {
                hmacSource.append(StringUtils.defaultString((String)ticketInfo.getAirlineName())).append(StringUtils.defaultString((String)ticketInfo.getCrewName())).append(StringUtils.defaultString((String)ticketInfo.getFlight())).append(StringUtils.defaultString((String)ticketInfo.getFreightSpaceClass())).append(StringUtils.defaultString((String)ticketInfo.getFromTo())).append(StringUtils.defaultString((String)ticketInfo.getDepartureArrivalTime()));
            }
        }
        if (this.hotelInfos != null) {
            for (HotelInfo hotelInfo : this.hotelInfos) {
                hmacSource.append(StringUtils.defaultString((String)hotelInfo.getHotelName())).append(StringUtils.defaultString((String)hotelInfo.getHotelAddress())).append(StringUtils.defaultString((String)hotelInfo.getRegistrantName())).append(StringUtils.defaultString((String)hotelInfo.getCheckInDate())).append(StringUtils.defaultString((String)hotelInfo.getCheckOutDate())).append(StringUtils.defaultString((String)hotelInfo.getRoomType()));
            }
        }
        if (this.travelInfos != null) {
            for (TravelInfo travelInfo : this.travelInfos) {
                hmacSource.append(StringUtils.defaultString((String)travelInfo.getSubItem())).append(StringUtils.defaultString((String)travelInfo.getCountry())).append(StringUtils.defaultString((String)travelInfo.getProductName())).append(StringUtils.defaultString((String)travelInfo.getStartDateTime())).append(StringUtils.defaultString((String)travelInfo.getName())).append(StringUtils.defaultString((String)travelInfo.getPeopleNum()));
            }
        }
        if (this.logisticsInfos != null) {
            for (LogisticsInfo logisticsInfo : this.logisticsInfos) {
                hmacSource.append(StringUtils.defaultString((String)logisticsInfo.getCountry())).append(StringUtils.defaultString((String)logisticsInfo.getGoodsType())).append(StringUtils.defaultString((String)logisticsInfo.getMailType())).append(StringUtils.defaultString((String)logisticsInfo.getLogisticsNumber())).append(StringUtils.defaultString((String)logisticsInfo.getName()));
            }
        }
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public List<TravelInfo> getTravelInfos() {
        return this.travelInfos;
    }

    public void setTravelInfos(List<TravelInfo> travelInfos) {
        this.travelInfos = travelInfos;
    }

    public List<LogisticsInfo> getLogisticsInfos() {
        return this.logisticsInfos;
    }

    public void setLogisticsInfos(List<LogisticsInfo> logisticsInfos) {
        this.logisticsInfos = logisticsInfos;
    }

    public OrderBuilder setFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public String getFileName() {
        return this.fileName;
    }
}

