/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.core.CipherAdapter;
import com.upay.sdk.core.Environment;
import com.upay.sdk.crypto.SdkEncryptDecryptSupport;
import com.upay.sdk.crypto.exception.EncryptDecryptNotSupportException;
import com.upay.sdk.exception.RequestException;
import com.upay.sdk.exception.UnknownException;
import java.io.IOException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CipherWrapper {
    static final Logger LOGGER = LoggerFactory.getLogger(CipherWrapper.class);
    private static final String DATA = "data";
    private static final String ENCRYPT_KEY = "encryptKey";
    private static final String MERCHANT_ID = "merchantId";
    private static final String REQUEST_ID = "requestId";
    private static final String PARTNER_ID = "partnerId";
    private static final ConcurrentHashMap<String, CipherAdapter> CIPHER_ADAPTER_CACHE = new ConcurrentHashMap();

    public static CipherAdapter getCipherAdapter(String merchantId, String partnerId) throws EncryptDecryptNotSupportException, CertificateException, IOException {
        String key = (String)StringUtils.defaultIfBlank((CharSequence)partnerId, (CharSequence)merchantId);
        return CIPHER_ADAPTER_CACHE.computeIfAbsent(key, k -> new CipherAdapter(key));
    }

    public static SdkEncryptDecryptSupport getSdkEncryptDecryptSupport(String merchantId, String partnerId) throws EncryptDecryptNotSupportException, CertificateException, IOException {
        CipherAdapter cipherAdapter = CipherWrapper.getCipherAdapter(merchantId, partnerId);
        return cipherAdapter.getSdkEncryptDecryptSupport();
    }

    public static JSONObject encryptWrap(String merchantId, String jsonObject) throws UnknownException {
        return CipherWrapper.encryptWrap(merchantId, JSONObject.parseObject((String)jsonObject));
    }

    public static JSONObject encryptWrap(String merchantId, JSONObject jsonObject) throws UnknownException {
        return CipherWrapper.encryptWrap(merchantId, null, jsonObject);
    }

    public static JSONObject encryptWrap(String merchantId, String partnerId, JSONObject jsonObject) throws UnknownException {
        String encryptKey;
        String data;
        String merchantAESKey = CipherWrapper.generateAlphaAndDigit(16);
        String requestId = jsonObject.getString(REQUEST_ID);
        String jsonStr = jsonObject.toJSONString();
        String publicKey = ConfigurationUtils.getPublicKey(StringUtils.isNotBlank((CharSequence)partnerId) ? partnerId : merchantId);
        if (StringUtils.isBlank((CharSequence)publicKey)) {
            throw new IllegalArgumentException("no publicKey configuration");
        }
        try {
            SdkEncryptDecryptSupport sdkEncryptDecryptSupport = CipherWrapper.getSdkEncryptDecryptSupport(merchantId, partnerId);
            data = sdkEncryptDecryptSupport.symmetricEncrypt(jsonStr, merchantAESKey);
            encryptKey = sdkEncryptDecryptSupport.asymmetricEncrypt(merchantAESKey, publicKey);
        }
        catch (Exception e) {
            JSONObject json = new JSONObject();
            json.put(Constants.STATUS, (Object)Constants.ERROR);
            json.put(Constants.ERROR_MSG, (Object)"RSA encrypt error");
            throw new RequestException(json);
        }
        JSONObject json = new JSONObject();
        json.put(DATA, (Object)data);
        json.put(ENCRYPT_KEY, (Object)encryptKey);
        json.put(MERCHANT_ID, (Object)merchantId);
        json.put(REQUEST_ID, (Object)requestId);
        if (StringUtils.isNotBlank((CharSequence)partnerId)) {
            json.put(PARTNER_ID, (Object)partnerId);
        }
        return json;
    }

    public static JSONObject decryptWrap(String jsonObject) throws UnknownException {
        return CipherWrapper.decryptWrap(JSON.parseObject((String)jsonObject));
    }

    public static JSONObject decryptWrap(JSONObject json) throws UnknownException {
        String partnerId;
        if (json == null) {
            return null;
        }
        String data = json.get((Object)DATA) == null ? null : String.valueOf(json.get((Object)DATA));
        String encryptKey = json.get((Object)ENCRYPT_KEY) == null ? null : String.valueOf(json.get((Object)ENCRYPT_KEY));
        String merchantId = json.get((Object)MERCHANT_ID) == null ? null : String.valueOf(json.get((Object)MERCHANT_ID));
        String string = partnerId = json.get((Object)PARTNER_ID) == null ? null : String.valueOf(json.get((Object)PARTNER_ID));
        if (data == null || encryptKey == null || merchantId == null) {
            throw new IllegalArgumentException(String.format("data:[%s],encryptKey:[%s],merchantId:[%s]", data, encryptKey, merchantId));
        }
        String publicKey = ConfigurationUtils.getPublicKey(StringUtils.isNotBlank((CharSequence)partnerId) ? partnerId : merchantId);
        if (StringUtils.isBlank((CharSequence)publicKey)) {
            throw new IllegalArgumentException("no publicKey configuration");
        }
        try {
            SdkEncryptDecryptSupport sdkEncryptDecryptSupport = CipherWrapper.getSdkEncryptDecryptSupport(merchantId, partnerId);
            String aesKey = sdkEncryptDecryptSupport.asymmetricDecrypt(encryptKey, publicKey);
            String realData = sdkEncryptDecryptSupport.symmetricDecrypt(data, aesKey);
            return StringUtils.isBlank((CharSequence)realData) ? null : JSON.parseObject((String)realData);
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
    }

    public static JSONObject bothEncryptWrap(String merchantId, JSONObject jsonObject) throws UnknownException {
        return CipherWrapper.bothEncryptWrap(merchantId, null, jsonObject);
    }

    public static JSONObject bothEncryptWrap(String merchantId, String partnerId, JSONObject jsonObject) throws UnknownException {
        String encryptKey;
        String data;
        try {
            CipherAdapter cipherAdapter = CipherWrapper.getCipherAdapter(merchantId, partnerId);
            SdkEncryptDecryptSupport sdkEncryptDecryptSupport = cipherAdapter.getSdkEncryptDecryptSupport();
            byte[] sourceHMAC = jsonObject.getBytes(Constants.HMAC);
            if (sourceHMAC == null || sourceHMAC.length == 1) {
                throw new IllegalArgumentException("hmac is empty!");
            }
            byte[] hamcData = sdkEncryptDecryptSupport.digest(sourceHMAC);
            String hmac = sdkEncryptDecryptSupport.sign(hamcData, cipherAdapter.getPrivateKey());
            jsonObject.put(Constants.HMAC, (Object)hmac);
            String randomKey = CipherWrapper.generateAlphaAndDigit(16);
            LOGGER.info("bothEncryptWrap jsonObject:{}", (Object)jsonObject);
            data = sdkEncryptDecryptSupport.symmetricEncrypt(jsonObject.toJSONString(), randomKey);
            encryptKey = sdkEncryptDecryptSupport.asymmetricEncrypt(randomKey, cipherAdapter.getPublicKey());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        JSONObject json = new JSONObject();
        json.put(DATA, (Object)data);
        json.put(ENCRYPT_KEY, (Object)encryptKey);
        json.put(MERCHANT_ID, (Object)merchantId);
        json.put(REQUEST_ID, (Object)jsonObject.getString(REQUEST_ID));
        if (StringUtils.isNotBlank((CharSequence)partnerId)) {
            json.put(PARTNER_ID, (Object)partnerId);
        }
        return json;
    }

    public static JSONObject bothDecryptWrap(JSONObject json) throws UnknownException {
        String realData;
        String realEncryptKey;
        SdkEncryptDecryptSupport sdkEncryptDecryptSupport;
        String data = json.get((Object)DATA) == null ? null : String.valueOf(json.get((Object)DATA));
        String encryptKey = json.get((Object)ENCRYPT_KEY) == null ? null : String.valueOf(json.get((Object)ENCRYPT_KEY));
        String merchantId = json.get((Object)MERCHANT_ID) == null ? null : String.valueOf(json.get((Object)MERCHANT_ID));
        String partnerId = json.get((Object)PARTNER_ID) == null ? null : String.valueOf(json.get((Object)PARTNER_ID));
        LOGGER.info("bothDecryptWrap merchantId:[{}],partnerId[{}]", (Object)merchantId, (Object)partnerId);
        if (data == null || encryptKey == null || merchantId == null) {
            return null;
        }
        try {
            CipherAdapter cipherAdapter = CipherWrapper.getCipherAdapter(merchantId, partnerId);
            sdkEncryptDecryptSupport = cipherAdapter.getSdkEncryptDecryptSupport();
            realEncryptKey = sdkEncryptDecryptSupport.asymmetricDecrypt(encryptKey, cipherAdapter.getPrivateKey());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        try {
            realData = sdkEncryptDecryptSupport.symmetricDecrypt(data, realEncryptKey);
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return StringUtils.isBlank((CharSequence)realData) ? null : JSON.parseObject((String)realData);
    }

    public static byte[] digest(String merchantId, String partnerId, byte[] data) throws EncryptDecryptNotSupportException, CertificateException, IOException {
        SdkEncryptDecryptSupport sdkEncryptDecryptSupport = CipherWrapper.getSdkEncryptDecryptSupport(merchantId, partnerId);
        return sdkEncryptDecryptSupport.digest(data);
    }

    public static boolean verify(String merchantId, String partnerId, byte[] data, String sign) throws Exception {
        CipherAdapter cipherAdapter = CipherWrapper.getCipherAdapter(merchantId, partnerId);
        SdkEncryptDecryptSupport sdkEncryptDecryptSupport = cipherAdapter.getSdkEncryptDecryptSupport();
        return sdkEncryptDecryptSupport.verify(data, cipherAdapter.getPublicKey(), sign);
    }

    public static boolean signAndVerify(String merchantId, String partnerId, String data, String hmac) throws Exception {
        CipherAdapter cipherAdapter = CipherWrapper.getCipherAdapter(merchantId, partnerId);
        SdkEncryptDecryptSupport sdkEncryptDecryptSupport = cipherAdapter.getSdkEncryptDecryptSupport();
        byte[] signData = sdkEncryptDecryptSupport.digest(data.getBytes(Environment.DEFAULT_CHARSET));
        return sdkEncryptDecryptSupport.verify(signData, cipherAdapter.getPublicKey(), hmac);
    }

    public static String generateAlphaAndDigit(int length) {
        if (length < 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        SecureRandom rand = new SecureRandom();
        SecureRandom randdata = new SecureRandom();
        block5: for (int i = 0; i < length; ++i) {
            int index = rand.nextInt(3);
            switch (index) {
                case 0: {
                    int data = randdata.nextInt(10);
                    sb.append(data);
                    continue block5;
                }
                case 1: {
                    int data = randdata.nextInt(26) + 65;
                    sb.append((char)data);
                    continue block5;
                }
                case 2: {
                    int data = randdata.nextInt(26) + 97;
                    sb.append((char)data);
                }
            }
        }
        return sb.toString();
    }
}

