/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.builder;

import com.alibaba.fastjson.JSONObject;
import com.upay.sdk.Constants;
import com.upay.sdk.SignPublisher;
import com.upay.sdk.core.CipherWrapper;
import com.upay.sdk.core.Environment;
import com.upay.sdk.exception.UnknownException;
import java.lang.reflect.Field;
import org.apache.commons.lang3.StringUtils;

public class BuilderSupport {
    public JSONObject build(String merchantId) {
        JSONObject json = new JSONObject(true);
        json.put(Constants.MERCHANT_ID, (Object)merchantId);
        return json;
    }

    protected JSONObject assembleBuild() {
        JSONObject json;
        Class<?> clazz = this.getClass();
        try {
            json = this.findField(clazz);
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return json;
    }

    private void putField(Class<?> clazz, JSONObject json) throws IllegalAccessException {
        for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            Object obj = field.get(this);
            if (obj == null) continue;
            json.put(field.getName(), obj);
        }
    }

    private JSONObject findField(Class<?> clazz) throws IllegalAccessException {
        JSONObject json = new JSONObject();
        for (Class<?> parent = clazz.getSuperclass(); parent != null && parent != Object.class; parent = parent.getSuperclass()) {
            this.putField(parent, json);
        }
        this.putField(clazz, json);
        return json;
    }

    protected String orderGenerateHmac() {
        String hmacSource;
        try {
            hmacSource = SignPublisher.generateHmacSource(this);
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return hmacSource;
    }

    public JSONObject buildRequestParam(String partnerId, String merchantId) {
        JSONObject json = this.assembleBuild();
        json.put(Constants.HMAC, (Object)this.orderGenerateHmac().getBytes(Environment.DEFAULT_CHARSET));
        if (StringUtils.isNotBlank((CharSequence)partnerId)) {
            return CipherWrapper.bothEncryptWrap(merchantId, partnerId, json);
        }
        return CipherWrapper.bothEncryptWrap(merchantId, json);
    }
}

